/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.generic.resource.impl;

import java.util.Map;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.DeepReadModifiableValueMapDecorator;
import org.apache.sling.api.wrappers.DeepReadValueMapDecorator;
import org.apache.sling.nosql.generic.adapter.NoSqlData;
import org.apache.sling.nosql.generic.resource.impl.NoSqlResourceProvider;
import org.apache.sling.nosql.generic.resource.impl.NoSqlValueMap;

class NoSqlResource
extends AbstractResource {
    private final NoSqlData data;
    private final ResourceResolver resourceResolver;
    private final NoSqlResourceProvider resourceProvider;
    private final ResourceMetadata metadata;

    public NoSqlResource(NoSqlData data, ResourceResolver resourceResolver, NoSqlResourceProvider resourceProvider) {
        this.data = data;
        this.resourceResolver = resourceResolver;
        this.resourceProvider = resourceProvider;
        this.metadata = new ResourceMetadata();
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public String getPath() {
        return this.data.getPath();
    }

    public String getResourceType() {
        return (String)this.getValueMap().get("sling:resourceType", (Object)"nt:unstructured");
    }

    public String getResourceSuperType() {
        return (String)this.getValueMap().get("sling:resourceSuperType", String.class);
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class || type == Map.class) {
            return (AdapterType)new DeepReadValueMapDecorator((Resource)this, (ValueMap)new NoSqlValueMap(this.data.getProperties(), (Resource)this, this.resourceProvider));
        }
        if (type == ModifiableValueMap.class) {
            return (AdapterType)new DeepReadModifiableValueMapDecorator((Resource)this, (ValueMap)new NoSqlValueMap(this.data.getProperties(), (Resource)this, this.resourceProvider));
        }
        return (AdapterType)super.adaptTo(type);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ", type=" + this.getResourceType() + ", superType=" + this.getResourceSuperType() + ", path=" + this.getPath();
    }
}

