/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal.mount;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.sling.jcr.base.internal.mount.ProxySession;
import org.apache.sling.jcr.base.internal.mount.ProxyWrapper;

public class ProxyPrivilegeManager
extends ProxyWrapper<PrivilegeManager>
implements PrivilegeManager {
    private final PrivilegeManager mount;

    public ProxyPrivilegeManager(ProxySession<?> mountSession, PrivilegeManager delegate, PrivilegeManager mount) {
        super(mountSession, delegate);
        this.mount = mount;
    }

    public Privilege[] getRegisteredPrivileges() throws RepositoryException {
        ArrayList<Privilege> result = new ArrayList<Privilege>();
        result.addAll(Arrays.asList(((PrivilegeManager)this.delegate).getRegisteredPrivileges()));
        result.addAll(Arrays.asList(this.mount.getRegisteredPrivileges()));
        return result.toArray(new Privilege[0]);
    }

    public Privilege getPrivilege(String privilegeName) throws AccessControlException, RepositoryException {
        try {
            return this.mount.getPrivilege(privilegeName);
        }
        catch (AccessControlException ex) {
            return ((PrivilegeManager)this.delegate).getPrivilege(privilegeName);
        }
    }

    public Privilege registerPrivilege(String privilegeName, boolean isAbstract, String[] declaredAggregateNames) throws AccessDeniedException, NamespaceException, RepositoryException {
        this.mount.registerPrivilege(privilegeName, isAbstract, declaredAggregateNames);
        return ((PrivilegeManager)this.delegate).registerPrivilege(privilegeName, isAbstract, declaredAggregateNames);
    }
}

