/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper.jcr;

import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.fsprovider.internal.mapper.ContentFile;
import org.apache.sling.fsprovider.internal.mapper.jcr.FsNode;
import org.apache.sling.fsprovider.internal.parser.ContentElement;

class FsNodeIterator
implements NodeIterator {
    private final ContentFile contentFile;
    private final ResourceResolver resolver;
    private final Iterator<Map.Entry<String, ContentElement>> children;

    public FsNodeIterator(ContentFile contentFile, ResourceResolver resolver) {
        this.contentFile = contentFile;
        this.resolver = resolver;
        ContentElement content = contentFile.getContent();
        this.children = content.getChildren().entrySet().iterator();
    }

    public boolean hasNext() {
        return this.children.hasNext();
    }

    public Object next() {
        return this.nextNode();
    }

    public Node nextNode() {
        Map.Entry<String, ContentElement> nextEntry = this.children.next();
        return new FsNode(this.contentFile.navigateToRelative(nextEntry.getKey()), this.resolver);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void skip(long skipNum) {
        throw new UnsupportedOperationException();
    }

    public long getSize() {
        throw new UnsupportedOperationException();
    }

    public long getPosition() {
        throw new UnsupportedOperationException();
    }
}

