/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core.processing.zopfli;

import com.googlecode.pngtastic.core.processing.zopfli.Buffer;
import com.googlecode.pngtastic.core.processing.zopfli.Cookie;
import com.googlecode.pngtastic.core.processing.zopfli.Deflate;
import com.googlecode.pngtastic.core.processing.zopfli.Options;
import java.util.zip.Adler32;

public final class Zopfli {
    private final Cookie cookie;

    public Zopfli(int masterBlockSize) {
        this.cookie = new Cookie(masterBlockSize);
    }

    private static long adler32(byte[] data) {
        Adler32 checksum = new Adler32();
        checksum.update(data);
        return checksum.getValue();
    }

    public synchronized Buffer compress(Options options, byte[] input) {
        Buffer output = new Buffer();
        this.compressZlib(options, input, output);
        return output;
    }

    private void compressZlib(Options options, byte[] input, Buffer output) {
        output.append((byte)120);
        output.append((byte)-38);
        Deflate.compress(this.cookie, options, input, output);
        long checksum = Zopfli.adler32(input);
        output.append((byte)((checksum >> 24) % 256L));
        output.append((byte)((checksum >> 16) % 256L));
        output.append((byte)((checksum >> 8) % 256L));
        output.append((byte)(checksum % 256L));
    }
}

