/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.impl.felix.utils.version;

import java.util.WeakHashMap;
import org.apache.sling.feature.io.impl.felix.utils.version.VersionCleaner;
import org.osgi.framework.Version;

public final class VersionTable {
    private static final WeakHashMap versions = new WeakHashMap();

    private VersionTable() {
    }

    public static Version getVersion(String version) {
        return VersionTable.getVersion(version, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getVersion(String version, boolean clean) {
        if (clean) {
            version = VersionCleaner.clean(version);
        }
        WeakHashMap weakHashMap = versions;
        synchronized (weakHashMap) {
            Version v = (Version)versions.get(version);
            if (v == null) {
                v = Version.parseVersion((String)version);
                versions.put(version, v);
            }
            return v;
        }
    }

    public static Version getVersion(int major, int minor, int micro) {
        return VersionTable.getVersion(major, minor, micro, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getVersion(int major, int minor, int micro, String qualifier) {
        String key = qualifier == null || qualifier.length() == 0 ? major + "." + minor + "." + micro : major + "." + minor + "." + micro + "." + qualifier;
        WeakHashMap weakHashMap = versions;
        synchronized (weakHashMap) {
            Version v = (Version)versions.get(key);
            if (v == null) {
                v = new Version(major, minor, micro, qualifier);
                versions.put(key, v);
            }
            return v;
        }
    }
}

