/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import relocated_for_contentpackage.javax.jcr.Session;
import relocated_for_contentpackage.org.apache.commons.io.IOUtils;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.CyclicDependencyException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.Dependency;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.DependencyException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.NoSuchPackageException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageId;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.DependencyReport;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.ExecutionPlan;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.ExecutionPlanBuilder;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.PackageTask;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.PackageTaskBuilder;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.PackageTaskOptions;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl.ExecutionPlanImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl.PackageTaskImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl.PackageTaskOptionsSerializer;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.RejectingEntityResolver;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.xml.serialize.FormattingXmlStreamWriter;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.xml.serialize.OutputFormat;

public class ExecutionPlanBuilderImpl
implements ExecutionPlanBuilder {
    private static final Logger log = LoggerFactory.getLogger(ExecutionPlanBuilderImpl.class);
    private static final String ATTR_VERSION = "version";
    private static final String TAG_EXECUTION_PLAN = "executionPlan";
    private static final String TAG_TASK = "task";
    private static final String ATTR_CMD = "cmd";
    private static final String ATTR_PACKAGE_ID = "packageId";
    public static final double SUPPORTED_VERSION = 1.0;
    protected double version = 1.0;
    private final List<TaskBuilder> tasks = new LinkedList<TaskBuilder>();
    private final PackageRegistry registry;
    private final PackageTaskOptionsSerializer optionsSerializer;
    private Session session;
    private ProgressTrackerListener listener;
    private ExecutionPlanImpl plan;
    private Set<PackageId> externalPackages = Collections.emptySet();

    ExecutionPlanBuilderImpl(PackageRegistry registry) {
        this.registry = registry;
        this.optionsSerializer = new PackageTaskOptionsSerializer();
    }

    @Override
    @NotNull
    public ExecutionPlanBuilder save(@NotNull OutputStream out) throws IOException, PackageException {
        this.validate();
        try (FormattingXmlStreamWriter writer = FormattingXmlStreamWriter.create(out, new OutputFormat(4, false));){
            writer.writeStartDocument();
            writer.writeStartElement(TAG_EXECUTION_PLAN);
            writer.writeAttribute(ATTR_VERSION, String.valueOf(this.version));
            for (PackageTask task : this.plan.getTasks()) {
                writer.writeStartElement(TAG_TASK);
                writer.writeAttribute(ATTR_CMD, task.getType().name().toLowerCase());
                writer.writeAttribute(ATTR_PACKAGE_ID, task.getPackageId().toString());
                this.optionsSerializer.save(writer, task.getOptions());
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    @NotNull
    public ExecutionPlanBuilder load(@NotNull InputStream in) throws IOException {
        this.tasks.clear();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new RejectingEntityResolver());
            Document document = builder.parse(in);
            Element doc = document.getDocumentElement();
            if (!TAG_EXECUTION_PLAN.equals(doc.getNodeName())) {
                throw new IOException("<executionPlan> expected.");
            }
            String v = doc.getAttribute(ATTR_VERSION);
            if (v == null || "".equals(v)) {
                v = "1.0";
            }
            this.version = Double.parseDouble(v);
            if (this.version > 1.0) {
                throw new IOException("version " + this.version + " not supported.");
            }
            this.read(doc);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Unable to create configuration XML parser", e);
        }
        catch (SAXException e) {
            throw new IOException("Configuration file syntax error.", e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return this;
    }

    private void read(Element elem) throws IOException {
        NodeList nl = elem.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            if (!TAG_TASK.equals(child.getNodeName())) {
                throw new IOException("<task> expected.");
            }
            this.readTask((Element)child);
        }
    }

    private void readTask(Element elem) throws IOException {
        PackageTask.Type type = PackageTask.Type.valueOf(elem.getAttribute(ATTR_CMD).toUpperCase());
        PackageId id = PackageId.fromString(elem.getAttribute(ATTR_PACKAGE_ID));
        PackageTaskBuilder packageTaskBuilder = this.addTask().with(id);
        PackageTaskOptions options = this.optionsSerializer.load(elem);
        if (options != null) {
            packageTaskBuilder.withOptions(options);
        }
        packageTaskBuilder.with(type);
    }

    @Override
    @NotNull
    public PackageTaskBuilder addTask() {
        TaskBuilder task = new TaskBuilder();
        this.tasks.add(task);
        this.plan = null;
        return task;
    }

    @Override
    @NotNull
    public ExecutionPlanBuilder with(@NotNull Session session) {
        this.session = session;
        return this;
    }

    @Override
    @NotNull
    public ExecutionPlanBuilder with(@NotNull ProgressTrackerListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    @NotNull
    public ExecutionPlanBuilder validate() throws IOException, PackageException {
        HashMap<PackageId, PackageTask> installTasks = new HashMap<PackageId, PackageTask>();
        HashMap<PackageId, PackageTask> uninstallTasks = new HashMap<PackageId, PackageTask>();
        HashMap<PackageId, PackageTaskImpl> removeTasks = new HashMap<PackageId, PackageTaskImpl>();
        ArrayList<PackageTask> packageTasks = new ArrayList<PackageTask>(this.tasks.size());
        for (TaskBuilder task : this.tasks) {
            if (task.id == null || task.type == null) {
                throw new PackageException("task builder must have package id and type defined.");
            }
            if (!this.registry.contains(task.id)) {
                throw new NoSuchPackageException("No such package: " + task.id);
            }
            PackageTaskImpl pTask = new PackageTaskImpl(task.id, task.type, task.option);
            switch (task.type) {
                case INSTALL: 
                case EXTRACT: {
                    installTasks.put(task.id, pTask);
                    break;
                }
                case UNINSTALL: {
                    uninstallTasks.put(task.id, pTask);
                    break;
                }
                case REMOVE: {
                    removeTasks.put(task.id, pTask);
                }
            }
        }
        for (PackageId id : uninstallTasks.keySet().toArray(new PackageId[uninstallTasks.size()])) {
            this.resolveUninstall(id, packageTasks, uninstallTasks, new HashSet<PackageId>(), ((PackageTask)uninstallTasks.get(id)).getOptions());
        }
        packageTasks.addAll(removeTasks.values());
        for (PackageId id : installTasks.keySet().toArray(new PackageId[installTasks.size()])) {
            PackageTask task = (PackageTask)installTasks.get(id);
            this.resolveInstall(id, packageTasks, installTasks, new HashSet<PackageId>(), task.getType(), task.getOptions());
        }
        for (PackageTask task : packageTasks) {
            log.info("- {}", (Object)task);
        }
        this.plan = new ExecutionPlanImpl(packageTasks);
        return this;
    }

    private void resolveInstall(PackageId id, List<PackageTask> packageTasks, Map<PackageId, PackageTask> installTasks, Set<PackageId> resolved, PackageTask.Type type, @Nullable PackageTaskOptions option) throws IOException, PackageException {
        if (resolved.contains(id)) {
            throw new CyclicDependencyException("Package has cyclic dependencies: " + id);
        }
        resolved.add(id);
        DependencyReport report = this.registry.analyzeDependencies(id, false);
        if (report.getUnresolvedDependencies().length > 0) {
            throw new DependencyException("Package " + id + " has unresolved dependencies: " + Dependency.toString(report.getUnresolvedDependencies()));
        }
        for (PackageId depId : report.getResolvedDependencies()) {
            if (installTasks.get(depId) == PackageTaskImpl.MARKER) continue;
            try (RegisteredPackage pkg = this.registry.open(depId);){
                if (pkg == null || pkg.isInstalled()) {
                    continue;
                }
            }
            this.resolveInstall(depId, packageTasks, installTasks, resolved, type, option);
        }
        PackageTask task = installTasks.get(id);
        if (task == PackageTaskImpl.MARKER) {
            return;
        }
        if (!this.externalPackages.contains(id)) {
            if (task == null) {
                task = new PackageTaskImpl(id, type, option);
            }
            packageTasks.add(task);
        }
        installTasks.put(id, PackageTaskImpl.MARKER);
    }

    private void resolveUninstall(PackageId id, List<PackageTask> packageTasks, Map<PackageId, PackageTask> uninstallTasks, Set<PackageId> resolved, @Nullable PackageTaskOptions option) throws IOException, PackageException {
        if (resolved.contains(id)) {
            throw new CyclicDependencyException("Package has cyclic dependencies: " + id);
        }
        resolved.add(id);
        for (PackageId depId : this.registry.usage(id)) {
            if (uninstallTasks.get(depId) == PackageTaskImpl.MARKER) continue;
            try (RegisteredPackage pkg = this.registry.open(depId);){
                if (pkg == null || !pkg.isInstalled()) {
                    continue;
                }
            }
            this.resolveUninstall(depId, packageTasks, uninstallTasks, resolved, option);
        }
        PackageTask task = uninstallTasks.get(id);
        if (task == PackageTaskImpl.MARKER) {
            return;
        }
        if (task == null) {
            task = new PackageTaskImpl(id, PackageTask.Type.UNINSTALL, option);
        }
        packageTasks.add(task);
        uninstallTasks.put(id, PackageTaskImpl.MARKER);
    }

    @Override
    @NotNull
    public ExecutionPlan execute() throws IOException, PackageException {
        if (this.plan == null) {
            this.validate();
        }
        if (this.session == null) {
            for (PackageTask task : this.plan.getTasks()) {
                if (task.getType() == PackageTask.Type.REMOVE) continue;
                throw new PackageException("Session not set in builder, but " + task + " task requires it.");
            }
        }
        return this.plan.with(this.registry).with(this.session).with(this.listener).execute();
    }

    @Override
    public ExecutionPlanBuilder with(Set<PackageId> externalPackages) {
        this.externalPackages = new HashSet<PackageId>(externalPackages);
        return this;
    }

    @Override
    public Set<PackageId> preview() throws IOException, PackageException {
        this.validate();
        if (this.plan.getTasks().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<PackageId> packages = new HashSet<PackageId>();
        for (PackageTask task : this.plan.getTasks()) {
            packages.add(task.getPackageId());
        }
        return packages;
    }

    private class TaskBuilder
    implements PackageTaskBuilder {
        private PackageId id;
        private PackageTask.Type type;
        private PackageTaskOptions option;

        private TaskBuilder() {
        }

        @Override
        public PackageTaskBuilder with(@NotNull PackageId id) {
            this.id = id;
            return this;
        }

        @Override
        @NotNull
        public ExecutionPlanBuilder with(@NotNull PackageTask.Type type) {
            this.type = type;
            return ExecutionPlanBuilderImpl.this;
        }

        @Override
        @NotNull
        public PackageTaskBuilder withOptions(@NotNull PackageTaskOptions option) {
            this.option = option;
            return this;
        }
    }
}

