/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.extensions.threaddump.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.extensions.threaddump.internal.ThreadDumpCommand;
import org.apache.sling.extensions.threaddump.internal.ThreadDumperPanel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
Thread.UncaughtExceptionHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Thread.UncaughtExceptionHandler oldHandler;

    public void start(BundleContext bundleContext) {
        this.oldHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.register(bundleContext, new String[]{"org.apache.felix.shell.Command"}, new ServiceFactory(){

            public void ungetService(Bundle bundle, ServiceRegistration reg, Object consoleObject) {
            }

            public Object getService(Bundle bundle, ServiceRegistration reg) {
                return new ThreadDumpCommand();
            }
        }, null);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("felix.webconsole.label", "slingthreads");
        ((Dictionary)props).put("felix.webconsole.title", "Threads");
        ((Dictionary)props).put("felix.webconsole.configprinter.modes", "always");
        ThreadDumperPanel tdp = new ThreadDumperPanel();
        this.register(bundleContext, new String[]{tdp.getClass().getName()}, tdp, props);
    }

    public void stop(BundleContext bundleContext) {
        Thread.setDefaultUncaughtExceptionHandler(this.oldHandler);
    }

    private void register(BundleContext context, String[] serviceNames, Object service, Dictionary<String, Object> properties) {
        Hashtable<String, String> props = properties == null ? new Hashtable<String, String>() : properties;
        ((Dictionary)props).put("service.description", "Thread Dumper (" + serviceNames[0] + ")");
        ((Dictionary)props).put("service.vendor", "Apache Software Foundation");
        context.registerService(serviceNames, service, props);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (e instanceof ThreadDeath) {
            this.log.error("Thread " + t + " has just been killed", e);
        } else {
            this.log.error("Uncaught exception in Thread " + t, e);
        }
        if (this.oldHandler != null) {
            this.oldHandler.uncaughtException(t, e);
        }
    }
}

