/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.agent.impl.AbstractDistributionAgentFactory;
import org.apache.sling.distribution.agent.impl.DistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.agent.impl.SimpleDistributionAgent;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.apache.sling.distribution.event.impl.DistributionEventFactory;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.monitor.impl.MonitoringDistributionQueueProvider;
import org.apache.sling.distribution.monitor.impl.SyncDistributionAgentMBean;
import org.apache.sling.distribution.monitor.impl.SyncDistributionAgentMBeanImpl;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.impl.exporter.RemoteDistributionPackageExporter;
import org.apache.sling.distribution.packaging.impl.importer.RemoteDistributionPackageImporter;
import org.apache.sling.distribution.queue.impl.ErrorQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.MultipleQueueDispatchingStrategy;
import org.apache.sling.distribution.queue.impl.jobhandling.JobHandlingDistributionQueueProvider;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.transport.impl.HttpConfiguration;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, property={"webconsole.configurationFactory.nameHint=Agent name: {name}"})
@Designate(ocd=Config.class, factory=true)
public class SyncDistributionAgentFactory
extends AbstractDistributionAgentFactory<SyncDistributionAgentMBean> {
    public static final String NAME = "name";
    public static final String TITLE = "title";
    public static final String DETAILS = "details";
    private static final String SERVICE_NAME = "serviceName";
    private static final String QUEUE_PROCESSING_ENABLED = "queue.processing.enabled";
    private static final String EXPORTER_ENDPOINTS = "packageExporter.endpoints";
    private static final String IMPORTER_ENDPOINTS = "packageImporter.endpoints";
    private static final String PULL_ITEMS = "pull.items";
    public static final String HTTP = "http.conn.timeout";
    public static final String TRIGGERS_TARGET = "triggers.target";
    public static final String RETRY_ATTEMPTS = "retry.attempts";
    public static final String RETRY_STRATEGY = "retry.strategy";
    public static final String PASSIVE_QUEUES = "passiveQueues";
    @Reference
    private Packaging packaging;
    @Reference(name="requestAuthorizationStrategy")
    private DistributionRequestAuthorizationStrategy requestAuthorizationStrategy;
    @Reference(name="transportSecretProvider")
    private DistributionTransportSecretProvider transportSecretProvider;
    @Reference(name="packageBuilder")
    private DistributionPackageBuilder packageBuilder;
    @Reference
    private DistributionEventFactory distributionEventFactory;
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private JobManager jobManager;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private SlingRepository slingRepository;

    public SyncDistributionAgentFactory() {
        super(SyncDistributionAgentMBean.class);
    }

    @Override
    @Activate
    protected void activate(BundleContext context, Map<String, Object> config) {
        super.activate(context, config);
    }

    @Override
    @Reference(name="triggers", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, bind="bindDistributionTrigger", unbind="unbindDistributionTrigger")
    protected void bindDistributionTrigger(DistributionTrigger distributionTrigger, Map<String, Object> config) {
        super.bindDistributionTrigger(distributionTrigger, config);
    }

    @Override
    protected void unbindDistributionTrigger(DistributionTrigger distributionTrigger, Map<String, Object> config) {
        super.unbindDistributionTrigger(distributionTrigger, config);
    }

    @Override
    @Deactivate
    protected void deactivate(BundleContext context) {
        super.deactivate(context);
    }

    @Override
    protected SimpleDistributionAgent createAgent(String agentName, BundleContext context, Map<String, Object> config, DefaultDistributionLog distributionLog) {
        String serviceName = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(SERVICE_NAME), null));
        boolean queueProcessingEnabled = PropertiesUtil.toBoolean((Object)config.get(QUEUE_PROCESSING_ENABLED), (boolean)true);
        String[] passiveQueues = PropertiesUtil.toStringArray((Object)config.get(PASSIVE_QUEUES), (String[])new String[0]);
        passiveQueues = SettingsUtils.removeEmptyEntries(passiveQueues, new String[0]);
        Object exporterEndpointsValue = config.get(EXPORTER_ENDPOINTS);
        Object importerEndpointsValue = config.get(IMPORTER_ENDPOINTS);
        String[] exporterEndpoints = PropertiesUtil.toStringArray((Object)exporterEndpointsValue, (String[])new String[0]);
        exporterEndpoints = SettingsUtils.removeEmptyEntries(exporterEndpoints);
        Map<String, String> importerEndpointsMap = SettingsUtils.toUriMap(importerEndpointsValue);
        int pullItems = PropertiesUtil.toInteger((Object)config.get(PULL_ITEMS), (int)Integer.MAX_VALUE);
        ErrorQueueDispatchingStrategy importQueueStrategy = null;
        HashSet<String> processingQueues = new HashSet<String>();
        TreeSet<String> queuesMap = new TreeSet<String>();
        queuesMap.addAll(importerEndpointsMap.keySet());
        queuesMap.addAll(Arrays.asList(passiveQueues));
        processingQueues.addAll(importerEndpointsMap.keySet());
        processingQueues.removeAll(Arrays.asList(passiveQueues));
        String[] queueNames = queuesMap.toArray(new String[queuesMap.size()]);
        MultipleQueueDispatchingStrategy exportQueueStrategy = new MultipleQueueDispatchingStrategy(queueNames);
        Integer timeout = PropertiesUtil.toInteger((Object)config.get(HTTP), (int)10) * 1000;
        HttpConfiguration httpConfiguration = new HttpConfiguration(timeout);
        RemoteDistributionPackageImporter packageImporter = new RemoteDistributionPackageImporter(distributionLog, this.transportSecretProvider, importerEndpointsMap, httpConfiguration);
        RemoteDistributionPackageExporter packageExporter = new RemoteDistributionPackageExporter(distributionLog, this.packageBuilder, this.transportSecretProvider, exporterEndpoints, pullItems, httpConfiguration);
        MonitoringDistributionQueueProvider queueProvider = new MonitoringDistributionQueueProvider(new JobHandlingDistributionQueueProvider(agentName, this.jobManager, context), context);
        DistributionRequestType[] allowedRequests = new DistributionRequestType[]{DistributionRequestType.PULL};
        String retryStrategy = SettingsUtils.removeEmptyEntry(PropertiesUtil.toString((Object)config.get(RETRY_STRATEGY), null));
        int retryAttepts = PropertiesUtil.toInteger((Object)config.get(RETRY_ATTEMPTS), (int)100);
        if ("errorQueue".equals(retryStrategy)) {
            importQueueStrategy = new ErrorQueueDispatchingStrategy(processingQueues.toArray(new String[processingQueues.size()]));
        }
        return new SimpleDistributionAgent(agentName, queueProcessingEnabled, processingQueues, serviceName, packageImporter, packageExporter, this.requestAuthorizationStrategy, queueProvider, exportQueueStrategy, importQueueStrategy, this.distributionEventFactory, this.resourceResolverFactory, this.slingRepository, distributionLog, allowedRequests, null, retryAttepts);
    }

    @Override
    protected SyncDistributionAgentMBean createMBeanAgent(DistributionAgent agent, Map<String, Object> osgiConfiguration) {
        return new SyncDistributionAgentMBeanImpl(agent, osgiConfiguration);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Agent - Sync Agents Factory", description="OSGi configuration factory for syncing agents")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="The name of the agent.")
        public String name() default "";

        @AttributeDefinition(name="Title", description="The display friendly title of the agent.")
        public String title() default "";

        @AttributeDefinition(name="Details", description="The display friendly details of the agent.")
        public String details() default "";

        @AttributeDefinition(name="Enabled", description="Whether or not to start the distribution agent.")
        public boolean enabled() default true;

        @AttributeDefinition(name="Service Name", description="The name of the service used to access the repository. If not set, the calling user ResourceResolver will be used")
        public String serviceName() default "";

        @AttributeDefinition(name="Log Level", description="The log level recorded in the transient log accessible via http.", options={@Option(label="debug", value="debug"), @Option(label="info", value="info"), @Option(label="warn", value="warn"), @Option(label="error", value="error")})
        public String log_level() default "info";

        @AttributeDefinition(name="Queue Processing Enabled", description="Whether or not the distribution agent should process packages in the queues.")
        public boolean queue_processing_enabled() default true;

        @AttributeDefinition(cardinality=100, name="passive queues", description="List of queues that should be disabled.These queues will gather all the packages until they are removed explicitly.")
        public String[] passiveQueues();

        @AttributeDefinition(cardinality=100, name="Exporter Endpoints", description="List of endpoints to which packages are sent (imported). The list can be given as a map in case a queue should be configured for each endpoint, e.g. queueName=http://...")
        public String[] packageExporter_endpoints();

        @AttributeDefinition(cardinality=100, name="Importer Endpoints", description="List of endpoints from which packages are received (exported)")
        public String[] packageImporter_endpoints();

        @AttributeDefinition(name="Retry Strategy", description="The strategy to apply after a certain number of failed retries.", options={@Option(label="none", value="none"), @Option(label="errorQueue", value="errorQueue")})
        public String retry_strategy() default "none";

        @AttributeDefinition(name="Retry attempts", description="The number of times to retry until the retry strategy is applied.")
        public int retry_attempts() default 100;

        @AttributeDefinition(name="Pull items", description="Number of subsequent pull requests to make.")
        public int pull_items() default 100;

        @AttributeDefinition(name="HTTP connection timeout", description="The connection timeout for HTTP requests (in seconds).")
        public int http_conn_timeout() default 10;

        @AttributeDefinition(name="Request Authorization Strategy", description="The target reference for the DistributionRequestAuthorizationStrategy used to authorize the access to distribution process,e.g. use target=(name=...) to bind to services by name.")
        public String requestAuthorizationStrategy_target() default "(name=default)";

        @AttributeDefinition(name="Transport Secret Provider", description="The target reference for the DistributionTransportSecretProvider used to obtain the credentials used for accessing the remote endpoints, e.g. use target=(name=...) to bind to services by name.")
        public String transportSecretProvider_target() default "(name=default)";

        @AttributeDefinition(name="Package Builder", description="The target reference for the DistributionPackageBuilder used to create distribution packages, e.g. use target=(name=...) to bind to services by name.")
        public String packageBuilder_target() default "(name=default)";

        @AttributeDefinition(name="Triggers", description="The target reference for DistributionTrigger used to trigger distribution, e.g. use target=(name=...) to bind to services by name.")
        public String triggers_target() default "(name=)";
    }
}

