/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.impl.support;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.commons.InstancesDiff;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={TopologyEventListener.class})
public class MetricReporter
implements TopologyEventListener {
    static final String METRICS_NAME_TOPOLOGY_CHANGING_EVENTS = "discovery.oak.topology.changing.events";
    static final String METRICS_NAME_TOPOLOGY_INIT_EVENTS = "discovery.oak.topology.init.events";
    static final String METRICS_NAME_TOPOLOGY_CHANGED_EVENTS = "discovery.oak.topology.changed.events";
    static final String METRICS_NAME_PROPERTY_CHANGED_EVENTS = "discovery.oak.property.changed.events";
    static final String METRICS_NAME_TOPOLOGY_IS_UNDEFINED = "discovery.oak.topology.is.undefined";
    static final String METRICS_NAME_LOCAL_CLUSTER_INSTANCES = "discovery.oak.local.cluster.instances";
    static final String METRICS_NAME_LOCAL_CLUSTER_JOINS = "discovery.oak.local.cluster.joins";
    static final String METRICS_NAME_LOCAL_CLUSTER_LEAVES = "discovery.oak.local.cluster.leaves";
    static final String METRICS_NAME_LOCAL_CLUSTER_LEADER_SWITCHES = "discovery.oak.local.cluster.leader.switches";
    static final String METRICS_NAME_LOCAL_CLUSTER_PROPERTIES = "discovery.oak.local.cluster.properties";
    static final String METRICS_NAME_OWN_IS_LEADER = "discovery.oak.own.is.leader";
    static final String METRICS_NAME_OWN_PROPERTIES = "discovery.oak.own.properties";
    static final String METRICS_NAME_REMOTE_CLUSTERS = "discovery.oak.remote.cluster";
    static final String METRICS_NAME_REMOTE_INSTANCES = "discovery.oak.remote.instances";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference(target="(name=sling)")
    MetricRegistry metricRegistry;
    private final List<String> registeredGaugeNameList = new LinkedList<String>();
    private final AtomicInteger initEvents = new AtomicInteger(0);
    private final AtomicInteger changingEvents = new AtomicInteger(0);
    private final AtomicInteger changedEvents = new AtomicInteger(0);
    private final AtomicLong propertyChangedEvents = new AtomicLong(0L);
    private final AtomicInteger topologyIsUndefined = new AtomicInteger(1);
    private final AtomicInteger localClusterInstances = new AtomicInteger(0);
    private final AtomicInteger localClusterJoins = new AtomicInteger(0);
    private final AtomicInteger localClusterLeaves = new AtomicInteger(0);
    private final AtomicInteger localClusterLeaderSwitches = new AtomicInteger(0);
    private final AtomicInteger localClusterProperties = new AtomicInteger(0);
    private final AtomicInteger ownIsLeader = new AtomicInteger(0);
    private final AtomicInteger ownProperties = new AtomicInteger(0);
    private final AtomicInteger remoteClusters = new AtomicInteger(0);
    private final AtomicInteger remoteInstances = new AtomicInteger(0);

    @Activate
    protected void activate() {
        this.logger.debug("activate: start");
        this.createGauge(METRICS_NAME_TOPOLOGY_INIT_EVENTS, this.initEvents::get);
        this.createGauge(METRICS_NAME_TOPOLOGY_CHANGING_EVENTS, this.changingEvents::get);
        this.createGauge(METRICS_NAME_TOPOLOGY_CHANGED_EVENTS, this.changedEvents::get);
        this.createGauge(METRICS_NAME_PROPERTY_CHANGED_EVENTS, this.propertyChangedEvents::get);
        this.createGauge(METRICS_NAME_TOPOLOGY_IS_UNDEFINED, this.topologyIsUndefined::get);
        this.createGauge(METRICS_NAME_LOCAL_CLUSTER_INSTANCES, this.localClusterInstances::get);
        this.createGauge(METRICS_NAME_LOCAL_CLUSTER_JOINS, this.localClusterJoins::get);
        this.createGauge(METRICS_NAME_LOCAL_CLUSTER_LEAVES, this.localClusterLeaves::get);
        this.createGauge(METRICS_NAME_LOCAL_CLUSTER_LEADER_SWITCHES, this.localClusterLeaderSwitches::get);
        this.createGauge(METRICS_NAME_LOCAL_CLUSTER_PROPERTIES, this.localClusterProperties::get);
        this.createGauge(METRICS_NAME_OWN_IS_LEADER, this.ownIsLeader::get);
        this.createGauge(METRICS_NAME_OWN_PROPERTIES, this.ownProperties::get);
        this.createGauge(METRICS_NAME_REMOTE_CLUSTERS, this.remoteClusters::get);
        this.createGauge(METRICS_NAME_REMOTE_INSTANCES, this.remoteInstances::get);
        this.logger.info("activate: done.");
    }

    private void createGauge(String gaugeName, Gauge gauge) {
        this.logger.debug("createGauge: registering gauge : " + gaugeName);
        this.metricRegistry.register(gaugeName, (Metric)gauge);
        this.registeredGaugeNameList.add(gaugeName);
    }

    @Deactivate
    protected void deactivate() {
        this.logger.debug("deactivate: deactivating.");
        this.unregisterGauges();
        this.logger.info("deactivate: done.");
    }

    private void unregisterGauges() {
        for (String registeredGaugeName : this.registeredGaugeNameList) {
            this.logger.debug("unregisterGauges : unregistering gauge : " + registeredGaugeName);
            this.metricRegistry.remove(registeredGaugeName);
        }
    }

    public void handleTopologyEvent(TopologyEvent event) {
        if (event == null) {
            return;
        }
        try {
            switch (event.getType()) {
                case TOPOLOGY_INIT: {
                    this.handleInit(event.getNewView());
                    return;
                }
                case TOPOLOGY_CHANGING: {
                    this.handleChanging();
                    return;
                }
                case TOPOLOGY_CHANGED: {
                    this.handleChanged(event.getOldView(), event.getNewView());
                    return;
                }
                case PROPERTIES_CHANGED: {
                    this.handlePropertiesChanged(event.getNewView());
                    return;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("handleTopologyEvent: got Exception " + e, (Throwable)e);
        }
    }

    private void handleInit(TopologyView newView) {
        this.initEvents.incrementAndGet();
        this.topologyIsUndefined.set(0);
        this.updateLocalClusterInstances(null, newView);
        this.updateProperties(newView);
        this.updateOwnIsLeader(newView);
        this.updateRemote(newView);
    }

    private void handleChanging() {
        this.changingEvents.incrementAndGet();
        this.topologyIsUndefined.set(1);
    }

    private void handleChanged(TopologyView oldView, TopologyView newView) {
        this.changedEvents.incrementAndGet();
        this.topologyIsUndefined.set(0);
        this.updateLocalClusterInstances(oldView, newView);
        this.updateLeaderSwitch(oldView, newView);
        this.updateProperties(newView);
        this.updateRemote(newView);
    }

    private void handlePropertiesChanged(TopologyView newView) {
        this.propertyChangedEvents.incrementAndGet();
        this.updateProperties(newView);
    }

    private void updateLocalClusterInstances(TopologyView oldViewOrNull, TopologyView newView) {
        ClusterView newLocalClusterView = newView.getLocalInstance().getClusterView();
        this.localClusterInstances.set(newLocalClusterView.getInstances().size());
        if (oldViewOrNull == null) {
            this.localClusterJoins.addAndGet(newLocalClusterView.getInstances().size());
        } else {
            ClusterView oldLocalClusterView = oldViewOrNull.getLocalInstance().getClusterView();
            InstancesDiff diff = new InstancesDiff(oldLocalClusterView, newLocalClusterView);
            Collection added = diff.added().get();
            Collection removed = diff.removed().get();
            if (added.size() > 0) {
                this.localClusterJoins.addAndGet(added.size());
            }
            if (removed.size() > 0) {
                this.localClusterLeaves.addAndGet(removed.size());
            }
        }
    }

    private void updateLeaderSwitch(TopologyView oldView, TopologyView newView) {
        InstanceDescription oldLeader = oldView.getLocalInstance().getClusterView().getLeader();
        InstanceDescription newLeader = newView.getLocalInstance().getClusterView().getLeader();
        if (!oldLeader.getSlingId().equals(newLeader.getSlingId())) {
            this.localClusterLeaderSwitches.incrementAndGet();
        }
        this.updateOwnIsLeader(newView);
    }

    private void updateOwnIsLeader(TopologyView newView) {
        if (newView.getLocalInstance().isLeader()) {
            this.ownIsLeader.set(1);
        } else {
            this.ownIsLeader.set(0);
        }
    }

    private void updateProperties(TopologyView newView) {
        this.ownProperties.set(newView.getLocalInstance().getProperties().size());
        ClusterView localCluster = newView.getLocalInstance().getClusterView();
        int properties = 0;
        for (InstanceDescription instance : localCluster.getInstances()) {
            properties += instance.getProperties().size();
        }
        this.localClusterProperties.set(properties);
    }

    private void updateRemote(TopologyView newView) {
        this.remoteClusters.set(newView.getClusterViews().size() - 1);
        String localClusterId = newView.getLocalInstance().getClusterView().getId();
        int instances = 0;
        for (ClusterView cluster : newView.getClusterViews()) {
            String clusterId = cluster.getId();
            if (clusterId.equals(localClusterId)) continue;
            instances += cluster.getInstances().size();
        }
        this.remoteInstances.set(instances);
    }
}

