/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.discovery.impl.setup;

import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.discovery.base.its.setup.VirtualInstance;
import org.apache.sling.discovery.impl.Config;
import org.apache.sling.discovery.impl.common.heartbeat.HeartbeatHandler;

public class FullJR2VirtualInstance extends VirtualInstance {

    private FullJR2VirtualInstanceBuilder fullBuilder;

    public FullJR2VirtualInstance(FullJR2VirtualInstanceBuilder builder) throws Exception {
        super(builder);
        fullBuilder = builder;
    }

    public HeartbeatHandler getHeartbeatHandler() {
        return (HeartbeatHandler) getViewChecker();
    }

    public void stopVoting() {
        fullBuilder.stopVoting();
    }

    public void analyzeVotings() throws Exception {
        ResourceResolver resourceResolver = getResourceResolverFactory().getServiceResourceResolver(null);
        fullBuilder.getVotingHandler().analyzeVotings(resourceResolver);
        resourceResolver.close();
    }

    public Config getFullConfig() {
        return fullBuilder.getConfig();
    }

}
