/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.commons.providers.spi.base;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryTestHelper {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryTestHelper.class);

    public static void dumpRepo(ResourceResolverFactory resourceResolverFactory) throws Exception {
        try (ResourceResolver resourceResolver = resourceResolverFactory.getServiceResourceResolver(null);){
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            logger.info("dumpRepo: ====== START =====");
            logger.info("dumpRepo: repo = " + String.valueOf(session.getRepository()));
            RepositoryTestHelper.dump(session.getRootNode());
            logger.info("dumpRepo: ======  END  =====");
        }
    }

    public static void dump(Node node) throws RepositoryException {
        Node child;
        if (node.getPath().equals("/jcr:system") || node.getPath().equals("/rep:policy")) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(node.getPath() + " [" + node.getPrimaryNodeType().getName() + "] ");
        NodeIterator it = node.getNodes();
        while (it.hasNext()) {
            child = it.nextNode();
            sb.append(child.getName() + ", ");
        }
        logger.info("dump: " + sb.toString());
        it = node.getNodes();
        while (it.hasNext()) {
            child = it.nextNode();
            RepositoryTestHelper.dump(child);
        }
    }
}

