/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.impl;

import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RepositoryInitializer.class}, property={"service.ranking:Integer=100"})
public class IndexUpdate
implements RepositoryInitializer {
    private static final Logger log = LoggerFactory.getLogger(IndexUpdate.class);

    public void initialize(@NotNull NodeBuilder builder) {
        log.info("Initializing Reference Index Updates");
        NodeBuilder indexRoot = builder.child("oak:index");
        this.amendSlingPageIndex(indexRoot);
    }

    private void amendSlingPageIndex(NodeBuilder indexRoot) {
        log.info("amendSlingPageIndex");
        NodeBuilder propertiesRoot = indexRoot.child("slingPage").child("indexRules").child("sling:Page").child("properties");
        NodeBuilder hideInSitemap = propertiesRoot.child("hideInSitemap");
        hideInSitemap.setProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME);
        hideInSitemap.setProperty("propertyIndex", (Object)true, Type.BOOLEAN);
        hideInSitemap.setProperty("name", (Object)"jcr:content/hideInSitemap", Type.STRING);
        hideInSitemap.setProperty("type", (Object)"Boolean", Type.STRING);
        hideInSitemap.setProperty("nullCheckEnabled", (Object)true, Type.BOOLEAN);
        NodeBuilder publishDate = propertiesRoot.child("publishDate");
        publishDate.setProperty("jcr:primaryType", (Object)"nt:unstructured", Type.NAME);
        publishDate.setProperty("propertyIndex", (Object)true, Type.BOOLEAN);
        publishDate.setProperty("name", (Object)"jcr:content/publishDate", Type.STRING);
        publishDate.setProperty("type", (Object)"String", Type.STRING);
        publishDate.setProperty("nullCheckEnabled", (Object)true, Type.BOOLEAN);
        publishDate.setProperty("ordered", (Object)true, Type.BOOLEAN);
    }
}

