/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.uri;

import java.net.URI;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.uri.SlingUriBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface SlingUri
extends RequestPathInfo {
    @NotNull
    public URI toUri();

    @NotNull
    public String toString();

    @Nullable
    public String getScheme();

    @Nullable
    public String getUserInfo();

    @Nullable
    public String getHost();

    public int getPort();

    @Override
    @Nullable
    public String getResourcePath();

    @Override
    @Nullable
    public String getSelectorString();

    @Override
    @NotNull
    public String[] getSelectors();

    @Override
    @Nullable
    public String getExtension();

    @NotNull
    public Map<String, String> getPathParameters();

    @Override
    @Nullable
    public String getSuffix();

    @Nullable
    public String getPath();

    @Nullable
    public String getQuery();

    @Nullable
    public String getFragment();

    @Nullable
    public String getSchemeSpecificPart();

    @Override
    @Nullable
    public Resource getSuffixResource();

    public boolean isPath();

    public boolean isAbsolutePath();

    public boolean isRelativePath();

    public boolean isAbsolute();

    public boolean isOpaque();

    @NotNull
    default public SlingUri adjust(@NotNull Consumer<SlingUriBuilder> builderConsumer) {
        SlingUriBuilder builder = SlingUriBuilder.createFrom(this);
        builderConsumer.accept(builder);
        return builder.build();
    }
}

