/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.projectsupport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.sling.launchpad.api.LaunchpadContentProvider;
import org.apache.sling.maven.projectsupport.ArtifactDefinition;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;

abstract class BundleListContentProvider
implements LaunchpadContentProvider {
    public static final String INSTALL_PATH_PREFIX = "resources/install";
    public static final int BOOTSTRAP_DEF_START_LEVEL = -1;
    public static final int ACTUAL_BOOTSTRAP_START_LEVEL = 1;
    private final File resourceProviderRoot;
    private static final List<String> EMPTY_STRING_LIST = Collections.emptyList();

    BundleListContentProvider(File resourceProviderRoot) {
        this.resourceProviderRoot = resourceProviderRoot;
    }

    private Iterator<String> handleBundlePathRoot(String path) {
        HashSet<String> levels = new HashSet<String>();
        for (StartLevel level : this.getInitializedBundleList().getStartLevels()) {
            if (level.getStartLevel() != -1) continue;
            levels.add("resources/bundles/1/");
        }
        return levels.iterator();
    }

    private Iterator<String> handleConfigPath() {
        if (this.getConfigDirectory().exists() && this.getConfigDirectory().isDirectory()) {
            File[] configFiles = this.getConfigDirectory().listFiles();
            ArrayList<String> fileNames = new ArrayList<String>();
            for (File cfgFile : configFiles) {
                fileNames.add("resources/config/" + cfgFile.getName());
            }
            return fileNames.iterator();
        }
        return EMPTY_STRING_LIST.iterator();
    }

    private Iterator<String> handleBundlesSubfolder(String path) {
        Iterator result = null;
        String startLevelInfo = path.substring("resources/bundles".length() + 1);
        try {
            int startLevel = Integer.parseInt(startLevelInfo);
            if (startLevel == 1) {
                ArrayList<String> bundles = new ArrayList<String>();
                this.addBundles(bundles, 1, null);
                this.addBundles(bundles, -1, null);
                result = bundles.iterator();
            }
        }
        catch (NumberFormatException e) {
            this.getLog().warn((CharSequence)("Invalid start level " + startLevelInfo + " in path " + path));
        }
        return result;
    }

    private void addBundles(Collection<String> bundles, int startLevel, String runMode) {
        for (StartLevel level : this.getInitializedBundleList().getStartLevels()) {
            if (level.getStartLevel() != startLevel) continue;
            for (Bundle bundle : level.getBundles()) {
                if (!this.runModeMatches(bundle, runMode)) continue;
                ArtifactDefinition d = new ArtifactDefinition(bundle, startLevel);
                try {
                    Artifact artifact = this.getArtifact(d);
                    bundles.add(artifact.getFile().toURI().toURL().toExternalForm());
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)"Unable to resolve artifact ", (Throwable)e);
                }
            }
        }
    }

    private boolean runModeMatches(Bundle b, String runMode) {
        if (runMode == null || runMode.length() == 0) {
            return b.getRunModes() == null || b.getRunModes().length() == 0;
        }
        return b.getRunModes() != null && b.getRunModes().contains(runMode);
    }

    private Iterator<String> handleResourcesRoot() {
        HashSet<String> subDirs = new HashSet<String>();
        subDirs.add("resources/bundles");
        subDirs.add("resources/config");
        subDirs.add("resources/corebundles");
        subDirs.add(INSTALL_PATH_PREFIX);
        HashSet<String> runModes = new HashSet<String>();
        for (StartLevel level : this.getInitializedBundleList().getStartLevels()) {
            for (Bundle bundle : level.getBundles()) {
                String modes = bundle.getRunModes();
                if (modes == null || modes.length() <= 0) continue;
                for (String m : modes.split(",")) {
                    runModes.add("." + m);
                }
            }
        }
        for (String m : runModes) {
            subDirs.add(INSTALL_PATH_PREFIX + m);
        }
        return subDirs.iterator();
    }

    private void addStartLevelSubdirs(Collection<String> children, String path, String runMode) {
        for (StartLevel level : this.getInitializedBundleList().getStartLevels()) {
            ArrayList<String> bundles = new ArrayList<String>();
            this.addBundles(bundles, level.getStartLevel(), runMode);
            if (bundles.isEmpty()) continue;
            int folderLevel = level.getStartLevel();
            if (folderLevel == -1) {
                folderLevel = 1;
            }
            children.add(path + "/" + folderLevel);
        }
    }

    private Iterator<String> handleInstallPath(String path) {
        String[] parts;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((parts = path.substring(INSTALL_PATH_PREFIX.length()).split("/")).length > 2) {
            throw new IllegalStateException("Cannot parse path " + path);
        }
        String runMode = parts[0].length() == 0 ? null : parts[0].substring(1);
        String startLevelInfo = parts.length > 1 ? parts[1] : null;
        HashSet<String> result = new HashSet<String>();
        if (runMode == null && startLevelInfo == null) {
            this.addStartLevelSubdirs(result, INSTALL_PATH_PREFIX, null);
        } else if (startLevelInfo == null) {
            this.addStartLevelSubdirs(result, path, runMode);
        } else {
            try {
                this.addBundles(result, Integer.parseInt(startLevelInfo), runMode);
            }
            catch (NumberFormatException e) {
                this.getLog().warn((CharSequence)("Invalid start level info " + startLevelInfo + " in path " + path));
            }
        }
        return result.iterator();
    }

    private Iterator<String> handleConfigSubpath(String path) {
        File f = this.getConfigFile(path);
        if (!f.exists()) {
            this.getLog().warn((CharSequence)("BundleListContentProvider cannot get children of config path: " + path));
            return EMPTY_STRING_LIST.iterator();
        }
        if (f.isFile()) {
            return EMPTY_STRING_LIST.iterator();
        }
        File[] configFiles = f.listFiles();
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File cfgFile : configFiles) {
            fileNames.add(path + "/" + cfgFile.getName());
        }
        return fileNames.iterator();
    }

    private File getConfigFile(String path) {
        return new File(FilenameUtils.concat((String)this.getConfigDirectory().getAbsolutePath(), (String)path.substring("resources/config".length() + 1)));
    }

    public Iterator<String> getChildren(String path) {
        Iterator<String> result = null;
        if (path.equals("resources/bundles")) {
            result = this.handleBundlePathRoot(path);
        } else if (path.equals("resources/corebundles")) {
            result = EMPTY_STRING_LIST.iterator();
        } else if (path.equals("resources/config")) {
            result = this.handleConfigPath();
        } else if (path.startsWith("resources/config")) {
            result = this.handleConfigSubpath(path);
        } else if (path.startsWith("resources/bundles")) {
            result = this.handleBundlesSubfolder(path);
        } else if (path.startsWith(INSTALL_PATH_PREFIX)) {
            result = this.handleInstallPath(path);
        } else if (path.equals("resources")) {
            result = this.handleResourcesRoot();
        } else if (path.startsWith("file:")) {
            result = EMPTY_STRING_LIST.iterator();
        } else {
            this.getLog().warn((CharSequence)("BundleListContentProvider cannot get children of path: " + path));
        }
        return result;
    }

    public URL getResource(String path) {
        File resourceFile;
        File configFile;
        if (path.startsWith("resources/config") && (configFile = this.getConfigFile(path)).exists()) {
            try {
                return configFile.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if ((resourceFile = new File(this.resourceProviderRoot, path)).exists()) {
            try {
                return resourceFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                this.getLog().error((CharSequence)"Unable to create URL for file", (Throwable)e);
                return null;
            }
        }
        URL fromClasspath = this.getClass().getResource("/" + path);
        if (fromClasspath != null) {
            return fromClasspath;
        }
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public InputStream getResourceAsStream(String path) {
        URL res = this.getResource(path);
        if (res != null) {
            try {
                return res.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    abstract BundleList getInitializedBundleList();

    abstract File getConfigDirectory();

    abstract Artifact getArtifact(ArtifactDefinition var1) throws MojoExecutionException;

    abstract Log getLog();
}

