/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.j2d;

import java.awt.Shape;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.referencing.internal.shared.AbstractShape;
import org.apache.sis.util.StringBuilders;

final class ShapeProperties {
    private final Shape geometry;
    private boolean isPolygon;

    public ShapeProperties(Shape geometry) {
        this.geometry = geometry;
    }

    private static double[] addPoint(double[] source, double[] target, int index) {
        if (index >= target.length) {
            target = Arrays.copyOf(target, index * 2);
        }
        System.arraycopy(source, 0, target, index, 2);
        return target;
    }

    private static float[] addPoint(float[] source, float[] target, int index) {
        if (index >= target.length) {
            target = Arrays.copyOf(target, index * 2);
        }
        System.arraycopy(source, 0, target, index, 2);
        return target;
    }

    private List<?> coordinates(double flatness) {
        PathIterator it = this.geometry.getPathIterator(null, flatness);
        this.isPolygon = true;
        if (AbstractShape.isFloat((Object)this.geometry)) {
            return this.coordinatesAsFloats(it);
        }
        return this.coordinatesAsDoubles(it);
    }

    public List<double[]> coordinatesAsDoubles() {
        this.isPolygon = true;
        return this.coordinatesAsDoubles(this.geometry.getPathIterator(null));
    }

    private List<double[]> coordinatesAsDoubles(PathIterator it) {
        ArrayList<double[]> polylines = new ArrayList<double[]>();
        double[] polyline = new double[10];
        double[] coords = new double[6];
        int i = 0;
        while (!it.isDone()) {
            switch (it.currentSegment(coords)) {
                case 0: {
                    if (i > 2) {
                        this.isPolygon = false;
                        polylines.add(Arrays.copyOf(polyline, i));
                    }
                    System.arraycopy(coords, 0, polyline, 0, 2);
                    i = 2;
                    break;
                }
                case 1: {
                    polyline = ShapeProperties.addPoint(coords, polyline, i);
                    i += 2;
                    break;
                }
                case 4: {
                    if (i > 2) {
                        if (polyline[0] != polyline[i - 2] || polyline[1] != polyline[i - 1]) {
                            polyline = ShapeProperties.addPoint(polyline, polyline, i);
                            i += 2;
                        }
                        polylines.add(Arrays.copyOf(polyline, i));
                    }
                    i = 0;
                    break;
                }
                default: {
                    throw new IllegalPathStateException();
                }
            }
            it.next();
        }
        if (i > 2) {
            this.isPolygon = false;
            polylines.add(Arrays.copyOf(polyline, i));
        }
        return polylines;
    }

    private List<float[]> coordinatesAsFloats(PathIterator it) {
        ArrayList<float[]> polylines = new ArrayList<float[]>();
        float[] polyline = new float[10];
        float[] coords = new float[6];
        int i = 0;
        while (!it.isDone()) {
            switch (it.currentSegment(coords)) {
                case 0: {
                    if (i > 2) {
                        this.isPolygon = false;
                        polylines.add(Arrays.copyOf(polyline, i));
                    }
                    System.arraycopy(coords, 0, polyline, 0, 2);
                    i = 2;
                    break;
                }
                case 1: {
                    polyline = ShapeProperties.addPoint(coords, polyline, i);
                    i += 2;
                    break;
                }
                case 4: {
                    if (i > 2) {
                        if (polyline[0] != polyline[i - 2] || polyline[1] != polyline[i - 1]) {
                            polyline = ShapeProperties.addPoint(polyline, polyline, i);
                            i += 2;
                        }
                        polylines.add(Arrays.copyOf(polyline, i));
                    }
                    i = 0;
                    break;
                }
                default: {
                    throw new IllegalPathStateException();
                }
            }
            it.next();
        }
        if (i > 2) {
            this.isPolygon = false;
            polylines.add(Arrays.copyOf(polyline, i));
        }
        return polylines;
    }

    public String toWKT(double flatness) {
        boolean isMulti;
        List<?> polylines = this.coordinates(flatness);
        switch (polylines.size()) {
            case 0: {
                return "POLYGON EMPTY";
            }
            case 1: {
                isMulti = false;
                break;
            }
            default: {
                isMulti = true;
            }
        }
        StringBuilder buffer = new StringBuilder(80);
        if (isMulti) {
            buffer.append("MULTI");
        }
        buffer.append(this.isPolygon ? "POLYGON" : "LINESTRING").append(' ');
        if (isMulti) {
            buffer.append('(');
        }
        for (int j = 0; j < polylines.size(); ++j) {
            Object polyline = polylines.get(j);
            if (j != 0) {
                buffer.append(", ");
            }
            buffer.append('(');
            if (this.isPolygon) {
                buffer.append('(');
            }
            int length = Array.getLength(polyline);
            for (int i = 0; i < length; ++i) {
                if (i != 0) {
                    if ((i & 1) == 0) {
                        buffer.append(',');
                    }
                    buffer.append(' ');
                }
                if (polyline instanceof double[]) {
                    buffer.append(((double[])polyline)[i]);
                } else {
                    buffer.append(((float[])polyline)[i]);
                }
                StringBuilders.trimFractionalPart((StringBuilder)buffer);
            }
            if (this.isPolygon) {
                buffer.append(')');
            }
            buffer.append(')');
        }
        if (isMulti) {
            buffer.append(')');
        }
        return buffer.toString();
    }
}

