/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import javax.measure.Unit;
import org.apache.sis.math.NumberType;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.CodeList;

public enum ElementKind {
    NAME,
    IDENTIFIER,
    NUMBER,
    INTEGER,
    UNIT,
    AXIS,
    CODE_LIST,
    PARAMETER,
    METHOD,
    DATUM,
    ENSEMBLE,
    SCOPE,
    EXTENT,
    CITATION,
    REMARKS,
    ERROR;


    public static ElementKind forType(Class<?> type) {
        if (type != null) {
            if (Datum.class.isAssignableFrom(type)) {
                return DATUM;
            }
            if (DefaultDatumEnsemble.class.isAssignableFrom(type)) {
                return ENSEMBLE;
            }
            if (OperationMethod.class.isAssignableFrom(type)) {
                return METHOD;
            }
            if (GeneralParameterValue.class.isAssignableFrom(type)) {
                return PARAMETER;
            }
            if (CoordinateSystemAxis.class.isAssignableFrom(type)) {
                return AXIS;
            }
            if (Identifier.class.isAssignableFrom(type)) {
                return IDENTIFIER;
            }
            if (Citation.class.isAssignableFrom(type)) {
                return CITATION;
            }
            if (CodeList.class.isAssignableFrom(type)) {
                return CODE_LIST;
            }
            if (Extent.class.isAssignableFrom(type)) {
                return EXTENT;
            }
            if (Unit.class.isAssignableFrom(type)) {
                return UNIT;
            }
            if (Number.class.isAssignableFrom(type)) {
                return NumberType.isInteger(type) ? INTEGER : NUMBER;
            }
        }
        return null;
    }
}

