/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.pending.geoapi.evolution;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.pending.geoapi.evolution.UnsupportedCodeList;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.cat.CodeListUID;
import org.opengis.util.CodeList;

public abstract class UnsupportedCodeListAdapter<ValueType extends UnsupportedCodeListAdapter<ValueType>>
extends XmlAdapter<ValueType, CodeList<?>> {
    protected CodeListUID identifier;

    protected UnsupportedCodeListAdapter() {
    }

    protected UnsupportedCodeListAdapter(CodeListUID value) {
        this.identifier = value;
    }

    protected abstract ValueType wrap(CodeListUID var1);

    protected abstract String getCodeListName();

    public final CodeList<?> unmarshal(ValueType adapter) {
        if (adapter == null) {
            return null;
        }
        return Types.forCodeName(UnsupportedCodeList.class, ((UnsupportedCodeListAdapter)((Object)adapter)).identifier.toString(), UnsupportedCodeList::valueOf);
    }

    public final ValueType marshal(CodeList<?> value) {
        if (value == null) {
            return null;
        }
        String name = value.name();
        int length = name.length();
        StringBuilder buffer = new StringBuilder(length);
        String codeListValue = this.toIdentifier(name, buffer, false);
        buffer.setLength(0);
        return this.wrap(new CodeListUID(Context.current(), this.getCodeListName(), codeListValue, null, this.toIdentifier(name, buffer, true)));
    }

    protected String toIdentifier(String name, StringBuilder buffer, boolean isValue) {
        int length = name.length();
        boolean toUpper = isValue;
        int i = 0;
        while (i < length) {
            int c = name.codePointAt(i);
            i += Character.charCount(c);
            if (c == 95) {
                if (isValue) {
                    c = 32;
                } else {
                    toUpper = true;
                    continue;
                }
            }
            if (toUpper) {
                c = Character.toUpperCase(c);
                toUpper = false;
            } else {
                c = Character.toLowerCase(c);
            }
            buffer.appendCodePoint(c);
        }
        return buffer.toString();
    }

    public abstract CodeListUID getElement();
}

