/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.stream;

import java.util.Objects;
import java.util.stream.BaseStream;

public abstract class BaseStreamWrapper<T, S extends BaseStream<T, S>>
implements BaseStream<T, S> {
    S toClose;

    BaseStreamWrapper() {
    }

    protected BaseStreamWrapper(S source) {
        this.toClose = (BaseStream)Objects.requireNonNull(source);
    }

    abstract S source();

    final IllegalStateException inactive() {
        return new IllegalStateException("This stream is no longer active.");
    }

    @Override
    public boolean isParallel() {
        return this.source().isParallel();
    }

    @Override
    public void close() {
        S s = this.toClose;
        if (s != null) {
            this.toClose = null;
            s.close();
        }
    }
}

