/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import org.apache.sis.util.Classes;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;

abstract class PrimaryKey {
    final Class<?> valueClass;

    PrimaryKey(Class<?> valueClass) {
        this.valueClass = valueClass;
    }

    static PrimaryKey create(Class<?> valueClass, Collection<String> columns) {
        if (columns.isEmpty()) {
            return null;
        }
        String c = (String)CollectionsExt.singletonOrNull(columns);
        return c != null ? new Single(valueClass, c) : new Composite(valueClass, columns);
    }

    public abstract List<String> getColumns();

    public String toString() {
        StringJoiner buffer = new StringJoiner(", ", "(", ")");
        this.getColumns().forEach(buffer::add);
        return String.valueOf(buffer) + " as " + Classes.getShortName(this.valueClass);
    }

    private static final class Single
    extends PrimaryKey {
        private final String column;

        Single(Class<?> valueClass, String column) {
            super(valueClass);
            this.column = column;
        }

        @Override
        public List<String> getColumns() {
            return List.of(this.column);
        }
    }

    private static final class Composite
    extends PrimaryKey {
        private final List<String> columns;

        Composite(Class<?> valueClass, Collection<String> columns) {
            super(valueClass);
            this.columns = UnmodifiableArrayList.wrap((Object[])((String[])columns.toArray(String[]::new)));
        }

        @Override
        public List<String> getColumns() {
            return this.columns;
        }
    }
}

