/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Map;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.CharacteristicTypeMap;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.util.internal.shared.AbstractMap;
import org.apache.sis.util.internal.shared.AbstractMapEntry;
import org.apache.sis.util.internal.shared.CloneAccess;
import org.apache.sis.util.internal.shared.Cloner;
import org.opengis.util.GenericName;

final class CharacteristicMap
extends AbstractMap<String, AbstractAttribute<?>>
implements CloneAccess {
    private final AbstractAttribute<?> source;
    AbstractAttribute<?>[] characterizedBy;
    final CharacteristicTypeMap types;

    CharacteristicMap(AbstractAttribute<?> source, CharacteristicTypeMap types) {
        this.source = source;
        this.types = types;
    }

    public CharacteristicMap clone() throws CloneNotSupportedException {
        CharacteristicMap clone = (CharacteristicMap)((Object)super.clone());
        AbstractAttribute<?>[] c = clone.characterizedBy;
        if (c != null) {
            clone.characterizedBy = c = (AbstractAttribute[])c.clone();
            Cloner cloner = new Cloner();
            for (int i = 0; i < c.length; ++i) {
                AbstractAttribute<?> attribute = c[i];
                if (!(attribute instanceof Cloneable)) continue;
                c[i] = (AbstractAttribute)cloner.clone(attribute);
            }
        }
        return clone;
    }

    public void clear() {
        this.characterizedBy = null;
    }

    public boolean isEmpty() {
        if (this.characterizedBy != null) {
            for (AbstractAttribute<?> attribute : this.characterizedBy) {
                if (attribute == null) continue;
                return false;
            }
        }
        return true;
    }

    public int size() {
        int n = 0;
        if (this.characterizedBy != null) {
            for (AbstractAttribute<?> attribute : this.characterizedBy) {
                if (attribute == null) continue;
                ++n;
            }
        }
        return n;
    }

    public AbstractAttribute<?> get(Object key) {
        Integer index;
        if (this.characterizedBy != null && (index = this.types.indices.get(key)) != null) {
            return this.characterizedBy[index];
        }
        return null;
    }

    public AbstractAttribute<?> remove(Object key) {
        Integer index;
        if (this.characterizedBy != null && (index = this.types.indices.get(key)) != null) {
            AbstractAttribute<?> previous = this.characterizedBy[index];
            this.characterizedBy[index.intValue()] = null;
            return previous;
        }
        return null;
    }

    private int indexOf(String key) {
        Integer index = this.types.indices.get(key);
        if (index == null) {
            throw new IllegalArgumentException(Resources.format((short)17, this.source.getName(), key));
        }
        return index;
    }

    final void verifyAttributeType(int index, DefaultAttributeType<?> type) {
        DefaultAttributeType<?> expected = this.types.characterizedBy[index];
        if (!expected.equals(type)) {
            GenericName en = expected.getName();
            GenericName an = type.getName();
            throw new IllegalArgumentException(String.valueOf(en).equals(String.valueOf(an)) ? Resources.format((short)45, en) : Resources.format((short)10, en.push(this.source.getName()), an));
        }
    }

    public AbstractAttribute<?> put(String key, AbstractAttribute<?> value) {
        int index = this.indexOf(key);
        this.verifyAttributeType(index, value.getType());
        if (this.characterizedBy == null) {
            this.characterizedBy = new AbstractAttribute[this.types.characterizedBy.length];
        }
        AbstractAttribute<?> previous = this.characterizedBy[index];
        this.characterizedBy[index] = value;
        return previous;
    }

    protected boolean addKey(String name) {
        int index = this.indexOf(name);
        if (this.characterizedBy == null) {
            this.characterizedBy = new AbstractAttribute[this.types.characterizedBy.length];
        }
        if (this.characterizedBy[index] == null) {
            this.characterizedBy[index] = this.types.characterizedBy[index].newInstance();
            return true;
        }
        return false;
    }

    protected boolean addValue(AbstractAttribute<?> value) {
        AbstractAttribute<?> previous;
        int index = this.indexOf(value.getName().toString());
        this.verifyAttributeType(index, value.getType());
        if (this.characterizedBy == null) {
            this.characterizedBy = new AbstractAttribute[this.types.characterizedBy.length];
        }
        if ((previous = this.characterizedBy[index]) == null) {
            this.characterizedBy[index] = value;
            return true;
        }
        if (previous.equals(value)) {
            return false;
        }
        throw new IllegalStateException(Resources.format((short)16, this.source.getName(), value.getName()));
    }

    protected AbstractMap.EntryIterator<String, AbstractAttribute<?>> entryIterator() {
        if (this.characterizedBy == null) {
            return null;
        }
        return new AbstractMap.EntryIterator<String, AbstractAttribute<?>>(){
            private int index = -1;
            private AbstractAttribute<?> value;

            protected boolean next() {
                while (++this.index < CharacteristicMap.this.characterizedBy.length) {
                    this.value = CharacteristicMap.this.characterizedBy[this.index];
                    if (this.value == null) continue;
                    return true;
                }
                this.value = null;
                return false;
            }

            protected String getKey() {
                return this.value.getType().getName().toString();
            }

            protected AbstractAttribute<?> getValue() {
                return this.value;
            }

            protected Map.Entry<String, AbstractAttribute<?>> getEntry() {
                return new Entry(this.index, this.value);
            }

            protected void remove() {
                CharacteristicMap.this.characterizedBy[this.index] = null;
            }
        };
    }

    private final class Entry
    extends AbstractMapEntry<String, AbstractAttribute<?>> {
        private final int index;
        private AbstractAttribute<?> value;

        Entry(int index, AbstractAttribute<?> value) {
            this.index = index;
            this.value = value;
        }

        public String getKey() {
            return this.value.getType().getName().toString();
        }

        public AbstractAttribute<?> getValue() {
            return this.value;
        }

        public AbstractAttribute<?> setValue(AbstractAttribute<?> value) {
            CharacteristicMap.this.verifyAttributeType(this.index, value.getType());
            AbstractAttribute<?> previous = this.value;
            CharacteristicMap.this.characterizedBy[this.index] = value;
            this.value = value;
            return previous;
        }
    }
}

