/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.gridded;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.pending.jdk.JDK19;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.internal.shared.AffineTransform2D;
import org.apache.sis.referencing.operation.gridded.GridFile;
import org.apache.sis.referencing.operation.gridded.GridLoader;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class LoadedGrid<C extends Quantity<C>, T extends Quantity<T>>
extends DatumShiftGrid<C, T> {
    private static final long serialVersionUID = -1690433946781367085L;
    private static final Cache<Object, LoadedGrid<?, ?>> CACHE = new Cache<Object, LoadedGrid<?, ?>>(4, 32768L, true){

        protected int cost(LoadedGrid<?, ?> grid) {
            int p = 1;
            for (Object data : grid.getData()) {
                if (data instanceof LoadedGrid) {
                    p += this.cost((LoadedGrid)data);
                    continue;
                }
                p *= Array.getLength(data);
            }
            return p;
        }
    };
    private final ParameterDescriptorGroup descriptor;
    private final URI[] files;
    protected final int scanlineStride;
    private final double periodX;
    public double accuracy;
    LoadedGrid<C, T>[] subgrids;

    LoadedGrid(Unit<C> coordinateUnit, Unit<T> translationUnit, boolean isCellValueRatio, double x0, double y0, double \u0394x, double \u0394y, int nx, int ny, ParameterDescriptorGroup descriptor, GridFile ... sources) throws NoninvertibleTransformException {
        super(coordinateUnit, new AffineTransform2D(\u0394x, 0.0, 0.0, \u0394y, x0, y0).inverse(), new int[]{nx, ny}, isCellValueRatio, translationUnit);
        this.files = new URI[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            this.files[i] = sources[i].resolved();
        }
        this.descriptor = descriptor;
        this.scanlineStride = nx;
        this.periodX = Units.isAngular(coordinateUnit) ? Math.rint(360.0 / Math.abs(\u0394x)) : 0.0;
    }

    LoadedGrid(LoadedGrid<C, T> other) {
        super(other);
        this.descriptor = other.descriptor;
        this.files = other.files;
        this.scanlineStride = other.scanlineStride;
        this.accuracy = other.accuracy;
        this.subgrids = other.subgrids;
        this.periodX = other.periodX;
    }

    LoadedGrid(LoadedGrid<C, T> other, AffineTransform2D gridToCRS, int nx, int ny) throws NoninvertibleTransformException {
        super(other.getCoordinateUnit(), gridToCRS.inverse(), new int[]{nx, ny}, other.isCellValueRatio(), other.getTranslationUnit());
        this.scanlineStride = nx;
        this.descriptor = other.descriptor;
        this.files = other.files;
        this.periodX = other.periodX == 0.0 ? 0.0 : Math.rint(360.0 / AffineTransforms2D.getScaleX0(gridToCRS));
    }

    public static LoadedGrid<?, ?> getOrLoad(GridFile f1, GridFile f2, Callable<LoadedGrid<?, ?>> loader) throws Exception {
        Serializable key = f1.resolved();
        if (f2 != null) {
            key = new AbstractMap.SimpleImmutableEntry<URI, URI>((URI)key, f2.resolved());
        }
        return (LoadedGrid)CACHE.getOrCreate((Object)key, loader);
    }

    public final void setSubGrids(Collection<LoadedGrid<C, T>> children) {
        if (this.subgrids != null) {
            throw new IllegalStateException();
        }
        this.subgrids = (LoadedGrid[])children.toArray(LoadedGrid[]::new);
    }

    private int getGridCount() {
        int n = 1;
        if (this.subgrids != null) {
            for (LoadedGrid<C, T> subgrid : this.subgrids) {
                n += subgrid.getGridCount();
            }
        }
        return n;
    }

    @Override
    public final String toString() {
        if (this.subgrids == null) {
            return super.toString();
        }
        DefaultTreeTable tree = new DefaultTreeTable(new TableColumn[]{TableColumn.NAME});
        this.toTree(tree.getRoot());
        return tree.toString();
    }

    private void toTree(TreeTable.Node branch) {
        Object label = super.toString();
        if (this.subgrids != null) {
            label = (String)label + " (" + this.getGridCount() + " grids)";
            for (LoadedGrid<C, T> subgrid : this.subgrids) {
                subgrid.toTree(branch.newChild());
            }
        }
        branch.setValue(TableColumn.NAME, label);
    }

    public final <NC extends Quantity<NC>, NT extends Quantity<NT>> LoadedGrid<NC, NT> castTo(Class<NC> coordinateType, Class<NT> translationType) {
        super.getCoordinateUnit().asType(coordinateType);
        super.getTranslationUnit().asType(translationType);
        return this;
    }

    public final LoadedGrid<C, T> useSharedData() {
        Object[] data = this.getData();
        for (LoadedGrid grid : CACHE.values()) {
            Object[] other = grid.getData();
            if (!Arrays.deepEquals(data, other)) continue;
            return this.setData(other);
        }
        return this;
    }

    protected abstract LoadedGrid<C, T> setData(Object[] var1);

    protected abstract Object[] getData();

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (super.equals(other)) {
            LoadedGrid that = (LoadedGrid)other;
            return Arrays.equals(this.files, that.files) && Arrays.deepEquals(this.getData(), that.getData());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.files);
    }

    @Override
    public double getCellPrecision() {
        return this.accuracy / 10.0;
    }

    @Override
    protected void replaceOutsideGridCoordinates(double[] gridCoordinates) {
        if (this.periodX != 0.0) {
            gridCoordinates[0] = Math.IEEEremainder(gridCoordinates[0], this.periodX);
        }
    }

    @Override
    public final ParameterDescriptorGroup getParameterDescriptors() {
        return this.descriptor;
    }

    @Override
    public final void getParameterValues(Parameters parameters) {
        int i = 0;
        for (GeneralParameterDescriptor gd : this.descriptor.descriptors()) {
            ParameterDescriptor d;
            if (!(gd instanceof ParameterDescriptor) || !URI.class.isAssignableFrom((d = (ParameterDescriptor)gd).getValueClass())) continue;
            if (i >= this.files.length) break;
            parameters.getOrCreate(d).setValue((Object)this.files[i++]);
        }
    }

    public static MathTransform createGeodeticTransformation(Class<? extends AbstractProvider> provider, MathTransformFactory factory, LoadedGrid<Angle, Angle> grid) throws FactoryException {
        MathTransform global = InterpolatedTransform.createGeodeticTransformation(factory, grid);
        LoadedGrid<C, T>[] subgrids = grid.subgrids;
        if (subgrids == null) {
            return global;
        }
        LinkedHashMap specializations = JDK19.newLinkedHashMap((int)subgrids.length);
        for (LoadedGrid<Angle, Angle> loadedGrid : subgrids) {
            try {
                Envelope domain = loadedGrid.getDomainOfValidity(Units.DEGREE);
                MathTransform st = LoadedGrid.createGeodeticTransformation(provider, factory, loadedGrid);
                if (specializations.putIfAbsent(domain, st) == null) continue;
                GridLoader.log(provider, Errors.forLocale(null).createLogRecord(Level.FINE, (short)37, (Object)domain));
            }
            catch (TransformException e) {
                throw new FactoryException((Throwable)e);
            }
        }
        return MathTransforms.specialize(global, specializations);
    }

    public static final class Double<C extends Quantity<C>, T extends Quantity<T>>
    extends LoadedGrid<C, T> {
        private static final long serialVersionUID = 3999271636016362364L;
        public final double[][] offsets;

        public Double(int dim, Unit<C> coordinateUnit, Unit<T> translationUnit, boolean isCellValueRatio, double x0, double y0, double \u0394x, double \u0394y, int nx, int ny, ParameterDescriptorGroup descriptor, GridFile ... files) throws NoninvertibleTransformException {
            super(coordinateUnit, translationUnit, isCellValueRatio, x0, y0, \u0394x, \u0394y, nx, ny, descriptor, files);
            this.offsets = new double[dim][Math.multiplyExact(nx, ny)];
        }

        private Double(LoadedGrid<C, T> grid, double[][] offsets) {
            super(grid);
            this.offsets = offsets;
        }

        @Override
        protected final LoadedGrid<C, T> setData(Object[] other) {
            return new Double<C, T>(this, (double[][])other);
        }

        @Override
        protected final Object[] getData() {
            return this.offsets;
        }

        @Override
        public final int getTranslationDimensions() {
            return this.offsets.length;
        }

        @Override
        public final double getCellValue(int dim, int gridX, int gridY) {
            return this.offsets[dim][gridX + gridY * this.scanlineStride];
        }
    }

    public static final class Float<C extends Quantity<C>, T extends Quantity<T>>
    extends LoadedGrid<C, T> {
        private static final long serialVersionUID = -9221609983475286496L;
        public final float[][] offsets;

        public Float(int dim, Unit<C> coordinateUnit, Unit<T> translationUnit, boolean isCellValueRatio, double x0, double y0, double \u0394x, double \u0394y, int nx, int ny, ParameterDescriptorGroup descriptor, GridFile ... files) throws NoninvertibleTransformException {
            super(coordinateUnit, translationUnit, isCellValueRatio, x0, y0, \u0394x, \u0394y, nx, ny, descriptor, files);
            this.offsets = new float[dim][Math.multiplyExact(nx, ny)];
        }

        private Float(LoadedGrid<C, T> grid, float[][] offsets) {
            super(grid);
            this.offsets = offsets;
        }

        @Override
        protected final LoadedGrid<C, T> setData(Object[] other) {
            return new Float<C, T>(this, (float[][])other);
        }

        @Override
        protected final Object[] getData() {
            return this.offsets;
        }

        @Override
        public final int getTranslationDimensions() {
            return this.offsets.length;
        }

        @Override
        public final double getCellValue(int dim, int gridX, int gridY) {
            return DecimalFunctions.floatToDouble((float)this.offsets[dim][gridX + gridY * this.scanlineStride]);
        }

        @Override
        public double getCellMean(int dim) {
            float[] data = this.offsets[dim];
            double sum = 0.0;
            for (float value : data) {
                sum += (double)value;
            }
            return sum / (double)data.length;
        }
    }
}

