/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.parameter.AbstractParameterDescriptor;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.referencing.CC_OperationParameterGroup;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

@XmlType(name="OperationParameterGroupType")
@XmlRootElement(name="OperationParameterGroup")
public class DefaultParameterDescriptorGroup
extends AbstractParameterDescriptor
implements ParameterDescriptorGroup {
    private static final long serialVersionUID = 6058599597772994456L;
    private List<GeneralParameterDescriptor> descriptors;

    public DefaultParameterDescriptorGroup(Map<String, ?> properties, int minimumOccurs, int maximumOccurs, GeneralParameterDescriptor ... parameters) {
        super(properties, minimumOccurs, maximumOccurs);
        parameters = (GeneralParameterDescriptor[])parameters.clone();
        DefaultParameterDescriptorGroup.verifyNames(properties, parameters);
        this.descriptors = DefaultParameterDescriptorGroup.asList(parameters);
    }

    public DefaultParameterDescriptorGroup(Map<String, ?> properties, ParameterDescriptorGroup parameters) {
        super(properties, parameters.getMinimumOccurs(), parameters.getMaximumOccurs());
        this.descriptors = parameters.descriptors();
        if (!(parameters instanceof DefaultParameterDescriptorGroup) || ((DefaultParameterDescriptorGroup)parameters).descriptors != this.descriptors) {
            GeneralParameterDescriptor[] p = (GeneralParameterDescriptor[])this.descriptors.toArray(GeneralParameterDescriptor[]::new);
            DefaultParameterDescriptorGroup.verifyNames(properties, p);
            this.descriptors = DefaultParameterDescriptorGroup.asList(p);
        }
    }

    DefaultParameterDescriptorGroup(Map<String, ?> properties, GeneralParameterDescriptor[] parameters) {
        super(properties, 1, 1);
        DefaultParameterDescriptorGroup.verifyNames(properties, parameters);
        this.descriptors = DefaultParameterDescriptorGroup.asList(parameters);
    }

    private static void verifyNames(Map<String, ?> properties, GeneralParameterDescriptor[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            GeneralParameterDescriptor parameter = parameters[i];
            ArgumentChecks.ensureNonNullElement((String)"parameters", (int)i, (Object)parameter);
            String name = parameter.getName().getCode();
            for (int j = 0; j < i; ++j) {
                if (!IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)parameters[j], name)) continue;
                throw new InvalidParameterNameException(Resources.forProperties(properties).getString((short)16, Verifier.getDisplayName(parameters[j]), j, name, i), name);
            }
        }
    }

    protected DefaultParameterDescriptorGroup(ParameterDescriptorGroup descriptor) {
        super((GeneralParameterDescriptor)descriptor);
        List<Object> c = descriptor.descriptors();
        this.descriptors = descriptor instanceof DefaultParameterDescriptorGroup && ((DefaultParameterDescriptorGroup)descriptor).descriptors == c ? c : DefaultParameterDescriptorGroup.asList((GeneralParameterDescriptor[])c.toArray(GeneralParameterDescriptor[]::new));
    }

    private static List<GeneralParameterDescriptor> asList(GeneralParameterDescriptor[] parameters) {
        switch (parameters.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(parameters[0]);
            }
            case 2: 
            case 3: {
                return UnmodifiableArrayList.wrap((Object[])parameters);
            }
        }
        return new AsList(parameters);
    }

    public static DefaultParameterDescriptorGroup castOrCopy(ParameterDescriptorGroup object) {
        return object == null || object instanceof DefaultParameterDescriptorGroup ? (DefaultParameterDescriptorGroup)object : new DefaultParameterDescriptorGroup(object);
    }

    public Class<? extends ParameterDescriptorGroup> getInterface() {
        return ParameterDescriptorGroup.class;
    }

    public List<GeneralParameterDescriptor> descriptors() {
        return this.descriptors;
    }

    public GeneralParameterDescriptor descriptor(String name) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull((String)"name", (Object)name);
        for (GeneralParameterDescriptor param : this.descriptors) {
            if (!name.equals(param.getName().getCode())) continue;
            return param;
        }
        GeneralParameterDescriptor fallback = null;
        GeneralParameterDescriptor ambiguity = null;
        for (GeneralParameterDescriptor param : this.descriptors) {
            if (!IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)param, name)) continue;
            if (fallback == null) {
                fallback = param;
                continue;
            }
            ambiguity = param;
        }
        if (fallback != null && ambiguity == null) {
            return fallback;
        }
        throw new ParameterNotFoundException(ambiguity != null ? Errors.format((short)2, (Object)IdentifiedObjects.toString((Identifier)fallback.getName()), (Object)IdentifiedObjects.toString((Identifier)ambiguity.getName()), (Object)name) : Resources.format((short)61, Verifier.getDisplayName(this), name), name);
    }

    public ParameterValueGroup createValue() {
        return new DefaultParameterValueGroup(this);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            switch (mode) {
                case STRICT: {
                    return this.descriptors.equals(((DefaultParameterDescriptorGroup)object).descriptors);
                }
            }
            return Utilities.deepEquals(this.descriptors(), (Object)((ParameterDescriptorGroup)object).descriptors(), (ComparisonMode)mode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)this.descriptors.hashCode();
    }

    DefaultParameterDescriptorGroup() {
        this.descriptors = Collections.emptyList();
    }

    @XmlElement(name="parameter", required=true)
    private GeneralParameterDescriptor[] getDescriptors() {
        return (GeneralParameterDescriptor[])this.descriptors().toArray(GeneralParameterDescriptor[]::new);
    }

    private void setDescriptors(GeneralParameterDescriptor[] parameters) {
        if (this.descriptors.isEmpty()) {
            DefaultParameterDescriptorGroup.verifyNames(null, parameters);
            this.descriptors = DefaultParameterDescriptorGroup.asList(parameters);
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultParameterValue.class, (String)"setDescriptors", (String)"parameter");
        }
    }

    final void merge(GeneralParameterDescriptor[] fromValues, Map<GeneralParameterDescriptor, GeneralParameterDescriptor> replacements) {
        fromValues = CC_OperationParameterGroup.merge(this.descriptors, fromValues, replacements);
        DefaultParameterDescriptorGroup.verifyNames(null, fromValues);
        this.descriptors = DefaultParameterDescriptorGroup.asList(fromValues);
    }

    private static final class AsList
    extends UnmodifiableArrayList<GeneralParameterDescriptor> {
        private static final long serialVersionUID = -2116304004367396735L;
        private volatile transient Set<GeneralParameterDescriptor> asSet;

        public AsList(GeneralParameterDescriptor[] array) {
            super((Object[])array);
        }

        public boolean contains(Object object) {
            Set<GeneralParameterDescriptor> s = this.asSet;
            if (s == null) {
                this.asSet = s = new HashSet<GeneralParameterDescriptor>((Collection<GeneralParameterDescriptor>)((Object)this));
            }
            return s.contains(object);
        }
    }
}

