/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.apache.sis.util.UnknownNameException;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.TypeNames;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

@XmlType(name="TypeName_Type")
@XmlRootElement(name="TypeName")
public class DefaultTypeName
extends DefaultLocalName
implements TypeName {
    private static final long serialVersionUID = 7571710679743017926L;
    private final Type javaType;

    protected DefaultTypeName(NameSpace scope, CharSequence name) throws UnknownNameException {
        super(scope, name);
        ClassNotFoundException cause;
        try {
            this.javaType = TypeNames.toClass(TypeNames.namespace(scope), super.toString());
            if (this.javaType != Void.TYPE) {
                return;
            }
            cause = null;
        }
        catch (ClassNotFoundException e) {
            cause = e;
        }
        throw new UnknownNameException(Errors.format((short)182, (Object)super.toFullyQualifiedName()), (Throwable)cause);
    }

    protected DefaultTypeName(NameSpace scope, CharSequence name, Type javaType) {
        super(scope, name);
        this.javaType = javaType;
    }

    public static DefaultTypeName castOrCopy(TypeName object) {
        if (object == null || object instanceof DefaultTypeName) {
            return (DefaultTypeName)object;
        }
        return new DefaultTypeName(object.scope(), (CharSequence)object.toInternationalString(), null);
    }

    public Optional<Type> toJavaType() {
        return Optional.ofNullable(this.javaType);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            return Objects.equals(this.javaType, ((DefaultTypeName)object).javaType);
        }
        return false;
    }

    @Override
    int computeHashCode() {
        return super.computeHashCode() ^ Objects.hashCode(this.javaType);
    }

    private DefaultTypeName() {
        this.javaType = null;
    }
}

