/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support.internal.support;

import org.springframework.osgi.service.importer.support.internal.support.RetryCallback;
import org.springframework.util.Assert;

public class RetryTemplate {
    private static final int hashCode = RetryTemplate.class.hashCode() * 13;
    public static final long DEFAULT_WAIT_TIME = 1000L;
    private final Object monitor = new Object();
    private final Object notificationLock;
    private long waitTime = 1000L;
    private static final long WAIT_THRESHOLD = 3L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetryTemplate(long waitTime, Object notificationLock) {
        Assert.isTrue((waitTime >= 0L ? 1 : 0) != 0, (String)"waitTime must be positive");
        Assert.notNull((Object)notificationLock, (String)"notificationLock must be non null");
        Object object = this.monitor;
        synchronized (object) {
            this.waitTime = waitTime;
            this.notificationLock = notificationLock;
        }
    }

    public RetryTemplate(Object notificationLock) {
        this(1000L, notificationLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(RetryCallback callback2) {
        Object result;
        long waitTime;
        Object object = this.monitor;
        synchronized (object) {
            waitTime = this.waitTime;
        }
        boolean retry = false;
        long initialStart = 0L;
        long start2 = 0L;
        long stop2 = 0L;
        long waitLeft = waitTime;
        boolean startWaiting = false;
        do {
            Object object2;
            if (callback2.isComplete(result = callback2.doWithRetry())) {
                if (startWaiting) {
                    this.callbackSucceeded(stop2);
                }
                return result;
            }
            if (!startWaiting) {
                startWaiting = true;
                this.onMissingTarget();
                initialStart = System.currentTimeMillis();
            }
            if (waitLeft > 0L) {
                try {
                    start2 = System.currentTimeMillis();
                    object2 = this.notificationLock;
                    synchronized (object2) {
                        this.notificationLock.wait(waitTime);
                    }
                    stop2 = System.currentTimeMillis();
                    waitLeft -= stop2 - start2;
                    stop2 -= initialStart;
                }
                catch (InterruptedException ex) {
                    stop2 = System.currentTimeMillis() - initialStart;
                    this.callbackFailed(stop2);
                    throw new RuntimeException("Retry failed; interrupted while waiting", ex);
                }
            }
            retry = false;
            object2 = this.monitor;
            synchronized (object2) {
                if (waitTime != this.waitTime) {
                    retry = true;
                    waitLeft = waitTime = this.waitTime;
                }
            }
        } while (retry || waitLeft > 3L);
        result = callback2.doWithRetry();
        stop2 = System.currentTimeMillis() - initialStart;
        if (callback2.isComplete(result)) {
            this.callbackSucceeded(stop2);
            return result;
        }
        this.callbackFailed(stop2);
        return null;
    }

    protected void onMissingTarget() {
    }

    protected void callbackSucceeded(long stop2) {
    }

    protected void callbackFailed(long stop2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(long waitTime) {
        Object object = this.monitor;
        synchronized (object) {
            this.waitTime = waitTime;
        }
        object = this.notificationLock;
        synchronized (object) {
            this.notificationLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWaitTime() {
        Object object = this.monitor;
        synchronized (object) {
            return this.waitTime;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RetryTemplate) {
            RetryTemplate oth = (RetryTemplate)other;
            return this.getWaitTime() == oth.getWaitTime();
        }
        return false;
    }

    public int hashCode() {
        return hashCode;
    }
}

