/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import java.io.IOException;
import java.nio.ByteBuffer;

public class Snappy {
    private static final SPI SNAPPY;

    public static boolean available() {
        return SNAPPY != null;
    }

    public static void uncompress(ByteBuffer compressed, ByteBuffer uncompressed) throws IOException {
        SNAPPY.uncompress(compressed, uncompressed);
    }

    public static void uncompress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
        SNAPPY.uncompress(input, inputOffset, length, output, outputOffset);
    }

    public static int compress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
        return SNAPPY.compress(input, inputOffset, length, output, outputOffset);
    }

    public static byte[] compress(String text) throws IOException {
        return SNAPPY.compress(text);
    }

    public static int maxCompressedLength(int length) {
        return SNAPPY.maxCompressedLength(length);
    }

    static {
        SPI attempt = null;
        String[] factories = System.getProperty("leveldb.snappy", "iq80,xerial").split(",");
        for (int i = 0; i < factories.length && attempt == null; ++i) {
            String name = factories[i];
            try {
                name = name.trim();
                if ("xerial".equals(name.toLowerCase())) {
                    name = "org.iq80.leveldb.util.Snappy$XerialSnappy";
                } else if ("iq80".equals(name.toLowerCase())) {
                    name = "org.iq80.leveldb.util.Snappy$IQ80Snappy";
                }
                attempt = (SPI)Thread.currentThread().getContextClassLoader().loadClass(name).newInstance();
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        SNAPPY = attempt;
    }

    public static class IQ80Snappy
    implements SPI {
        @Override
        public int uncompress(ByteBuffer compressed, ByteBuffer uncompressed) throws IOException {
            int outputOffset;
            byte[] output;
            int length;
            int inputOffset;
            byte[] input;
            if (compressed.hasArray()) {
                input = compressed.array();
                inputOffset = compressed.arrayOffset() + compressed.position();
                length = compressed.remaining();
            } else {
                input = new byte[compressed.remaining()];
                inputOffset = 0;
                length = input.length;
                compressed.mark();
                compressed.get(input);
                compressed.reset();
            }
            if (uncompressed.hasArray()) {
                output = uncompressed.array();
                outputOffset = uncompressed.arrayOffset() + uncompressed.position();
            } else {
                int t = org.iq80.snappy.Snappy.getUncompressedLength(input, inputOffset);
                output = new byte[t];
                outputOffset = 0;
            }
            int count = org.iq80.snappy.Snappy.uncompress(input, inputOffset, length, output, outputOffset);
            if (uncompressed.hasArray()) {
                uncompressed.limit(uncompressed.position() + count);
            } else {
                int p = uncompressed.position();
                uncompressed.limit(uncompressed.capacity());
                uncompressed.put(output, 0, count);
                uncompressed.flip().position(p);
            }
            return count;
        }

        @Override
        public int uncompress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
            return org.iq80.snappy.Snappy.uncompress(input, inputOffset, length, output, outputOffset);
        }

        @Override
        public int compress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
            return org.iq80.snappy.Snappy.compress(input, inputOffset, length, output, outputOffset);
        }

        @Override
        public byte[] compress(String text) throws IOException {
            byte[] uncomressed = text.getBytes("UTF-8");
            byte[] compressedOut = new byte[this.maxCompressedLength(uncomressed.length)];
            int compressedSize = this.compress(uncomressed, 0, uncomressed.length, compressedOut, 0);
            byte[] trimmedBuffer = new byte[compressedSize];
            System.arraycopy(compressedOut, 0, trimmedBuffer, 0, compressedSize);
            return trimmedBuffer;
        }

        @Override
        public int maxCompressedLength(int length) {
            return org.iq80.snappy.Snappy.maxCompressedLength(length);
        }

        static {
            try {
                new IQ80Snappy().compress("test");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class XerialSnappy
    implements SPI {
        @Override
        public int uncompress(ByteBuffer compressed, ByteBuffer uncompressed) throws IOException {
            return org.xerial.snappy.Snappy.uncompress((ByteBuffer)compressed, (ByteBuffer)uncompressed);
        }

        @Override
        public int uncompress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
            return org.xerial.snappy.Snappy.uncompress((byte[])input, (int)inputOffset, (int)length, (byte[])output, (int)outputOffset);
        }

        @Override
        public int compress(byte[] input, int inputOffset, int length, byte[] output, int outputOffset) throws IOException {
            return org.xerial.snappy.Snappy.compress((byte[])input, (int)inputOffset, (int)length, (byte[])output, (int)outputOffset);
        }

        @Override
        public byte[] compress(String text) throws IOException {
            return org.xerial.snappy.Snappy.compress((String)text);
        }

        @Override
        public int maxCompressedLength(int length) {
            return org.xerial.snappy.Snappy.maxCompressedLength((int)length);
        }

        static {
            try {
                org.xerial.snappy.Snappy.compress((String)"test");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface SPI {
        public int uncompress(ByteBuffer var1, ByteBuffer var2) throws IOException;

        public int uncompress(byte[] var1, int var2, int var3, byte[] var4, int var5) throws IOException;

        public int compress(byte[] var1, int var2, int var3, byte[] var4, int var5) throws IOException;

        public byte[] compress(String var1) throws IOException;

        public int maxCompressedLength(int var1);
    }
}

