/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.ArrayElement;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class UnsignedLongElement
extends AtomicElement<UnsignedLong> {
    private final UnsignedLong _value;

    UnsignedLongElement(Element parent, Element prev, UnsignedLong ul) {
        super(parent, prev);
        this._value = ul;
    }

    @Override
    public int size() {
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.TINY) {
                if (this._value.longValue() == 0L) {
                    return 0;
                }
                parent.setConstructorType(ArrayElement.SMALL);
            }
            if (parent.constructorType() == ArrayElement.SMALL) {
                if (0L <= this._value.longValue() && this._value.longValue() <= 255L) {
                    return 1;
                }
                parent.setConstructorType(ArrayElement.LARGE);
            }
            return 8;
        }
        return 0L == this._value.longValue() ? 1 : (1L <= this._value.longValue() && this._value.longValue() <= 255L ? 2 : 9);
    }

    @Override
    public UnsignedLong getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.ULONG;
    }

    @Override
    public int encode(ByteBuffer b) {
        int size2 = this.size();
        if (size2 > b.remaining()) {
            return 0;
        }
        switch (size2) {
            case 1: {
                if (this.isElementOfArray()) {
                    b.put((byte)this._value.longValue());
                    break;
                }
                b.put((byte)68);
                break;
            }
            case 2: {
                b.put((byte)83);
                b.put((byte)this._value.longValue());
                break;
            }
            case 9: {
                b.put((byte)-128);
            }
            case 8: {
                b.putLong(this._value.longValue());
            }
        }
        return size2;
    }
}

