/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import javax.servlet.Servlet;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.whiteboard.internal.ExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.WebApplication;
import org.ops4j.pax.web.extender.whiteboard.internal.element.WebElement;
import org.ops4j.pax.web.extender.whiteboard.runtime.DefaultHttpContextMapping;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTracker<T, W extends WebElement>
implements ServiceTrackerCustomizer<T, W> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTracker.class);
    private final ExtenderContext extenderContext;
    private final BundleContext bundleContext;

    AbstractTracker(ExtenderContext extenderContext, BundleContext bundleContext) {
        this.extenderContext = extenderContext;
        this.bundleContext = AbstractTracker.validateBundleContext(bundleContext);
    }

    protected final ServiceTracker<T, W> create(Class<? extends T> trackedClass) {
        return new ServiceTracker(this.bundleContext, AbstractTracker.createFilter(this.bundleContext, trackedClass), (ServiceTrackerCustomizer)this);
    }

    @SafeVarargs
    protected final ServiceTracker<T, W> create(Class<? extends T> ... trackedClass) {
        return new ServiceTracker(this.bundleContext, AbstractTracker.createFilter(this.bundleContext, trackedClass), (ServiceTrackerCustomizer)this);
    }

    private static Filter createFilter(BundleContext bundleContext, Class<?> trackedClass) {
        String filter = "(objectClass=" + trackedClass.getName() + ")";
        try {
            return bundleContext.createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    private static Filter createFilter(BundleContext bundleContext, Class<?> ... trackedClass) {
        if (trackedClass.length == 1) {
            return AbstractTracker.createFilter(bundleContext, trackedClass[0]);
        }
        StringBuilder filter = new StringBuilder();
        filter.append("(|");
        for (Class<?> clazz : trackedClass) {
            filter.append("(").append("objectClass").append("=").append(clazz.getName()).append(")");
        }
        filter.append(")");
        try {
            return bundleContext.createFilter(filter.toString());
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    private static BundleContext validateBundleContext(BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        return bundleContext;
    }

    public W addingService(ServiceReference<T> serviceReference) {
        LOG.debug("Service available {}", serviceReference);
        Object registered = this.bundleContext.getService(serviceReference);
        Boolean sharedHttpContext = Boolean.parseBoolean((String)serviceReference.getProperty("httpContext.shared"));
        W webElement = this.createWebElement(serviceReference, registered);
        if (webElement != null) {
            String httpContextId = webElement.getHttpContextId();
            WebApplication webApplication = this.extenderContext.getWebApplication(serviceReference.getBundle(), httpContextId, sharedHttpContext);
            if (httpContextId == null && !webApplication.hasHttpContextMapping()) {
                webApplication.setHttpContextMapping(new DefaultHttpContextMapping());
            }
            webApplication.addWebElement((WebElement)webElement);
            return webElement;
        }
        this.bundleContext.ungetService(serviceReference);
        return null;
    }

    public void modifiedService(ServiceReference<T> reference, W service) {
    }

    public void removedService(ServiceReference<T> serviceReference, W webElement) {
        LOG.debug("Service removed {}", serviceReference);
        Boolean sharedHttpContext = Boolean.parseBoolean((String)serviceReference.getProperty("httpContext.shared"));
        WebApplication webApplication = this.extenderContext.getExistingWebApplication(serviceReference.getBundle(), webElement.getHttpContextId(), sharedHttpContext);
        boolean remove = true;
        if (sharedHttpContext.booleanValue()) {
            Integer sharedWebApplicationCounter = this.extenderContext.getSharedWebApplicationCounter(webApplication);
            if (sharedWebApplicationCounter != null && sharedWebApplicationCounter > 0) {
                remove = false;
                Integer reduceSharedWebApplicationCount = this.extenderContext.reduceSharedWebApplicationCount(webApplication);
                if (reduceSharedWebApplicationCount == 0) {
                    remove = true;
                }
            }
            Object registered = this.bundleContext.getService(serviceReference);
            if (!remove && Servlet.class.isAssignableFrom(registered.getClass())) {
                remove = true;
            }
            this.bundleContext.ungetService(serviceReference);
        }
        if (webApplication != null && remove && webApplication.removeWebElement((WebElement)webElement)) {
            this.extenderContext.removeWebApplication(webApplication);
        }
    }

    abstract W createWebElement(ServiceReference<T> var1, T var2);
}

