/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.blueprint.context.impl;

import java.beans.PropertyDescriptor;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.apache.aries.blueprint.mutable.MutableValueMetadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xbean.blueprint.context.impl.XBeanNamespaceHandler;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QNameHelper {
    private static final Log log = LogFactory.getLog(QNameHelper.class);

    public static Metadata createQNameMetadata(Element element, String qualifiedName, ParserContext parserContext) {
        MutableBeanMetadata beanMetadata = (MutableBeanMetadata)parserContext.createMetadata(MutableBeanMetadata.class);
        beanMetadata.setClassName(QName.class.getName());
        int index = qualifiedName.indexOf(58);
        if (index >= 0) {
            String prefix = qualifiedName.substring(0, index);
            String localName = qualifiedName.substring(index + 1);
            String uri = QNameHelper.recursiveGetAttributeValue(element, "xmlns:" + prefix);
            beanMetadata.addArgument(QNameHelper.valueMetadata(uri, parserContext), String.class.getName(), 0);
            beanMetadata.addArgument(QNameHelper.valueMetadata(localName, parserContext), String.class.getName(), 1);
            beanMetadata.addArgument(QNameHelper.valueMetadata(prefix, parserContext), String.class.getName(), 2);
        } else {
            String uri = QNameHelper.recursiveGetAttributeValue(element, "xmlns");
            if (uri != null) {
                beanMetadata.addArgument(QNameHelper.valueMetadata(uri, parserContext), String.class.getName(), 0);
                beanMetadata.addArgument(QNameHelper.valueMetadata(qualifiedName, parserContext), String.class.getName(), 1);
            } else {
                beanMetadata.addArgument(QNameHelper.valueMetadata(qualifiedName, parserContext), String.class.getName(), 0);
            }
        }
        return beanMetadata;
    }

    private static Metadata valueMetadata(String stringValue, ParserContext parserContext) {
        MutableValueMetadata value = (MutableValueMetadata)parserContext.createMetadata(MutableValueMetadata.class);
        value.setStringValue(stringValue);
        return value;
    }

    public static String recursiveGetAttributeValue(Element element, String attributeName) {
        Node parentNode;
        String answer;
        block3: {
            answer = null;
            try {
                answer = element.getAttribute(attributeName);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block3;
                log.trace((Object)("Caught exception looking up attribute: " + attributeName + " on element: " + element + ". Cause: " + e), (Throwable)e);
            }
        }
        if ((answer == null || answer.length() == 0) && (parentNode = element.getParentNode()) instanceof Element) {
            return QNameHelper.recursiveGetAttributeValue((Element)parentNode, attributeName);
        }
        return answer;
    }

    public static void coerceNamespaceAwarePropertyValues(MutableBeanMetadata bd, Element element, PropertyDescriptor descriptor, ParserContext parserContext) {
        Metadata value;
        String name;
        BeanProperty propertyValue;
        if (descriptor.getPropertyType() == null) {
            return;
        }
        if (descriptor.getPropertyType().isAssignableFrom(QName.class)) {
            Metadata value2;
            String name2 = descriptor.getName();
            BeanProperty propertyValue2 = XBeanNamespaceHandler.propertyByName(name2, (BeanMetadata)bd);
            if (propertyValue2 != null && (value2 = propertyValue2.getValue()) instanceof ValueMetadata) {
                bd.removeProperty(propertyValue2);
                Metadata valueMetadata = QNameHelper.createQNameMetadata(element, ((ValueMetadata)value2).getStringValue(), parserContext);
                bd.addProperty(name2, valueMetadata);
            }
        } else if (descriptor.getPropertyType().isAssignableFrom(QName[].class) && (propertyValue = XBeanNamespaceHandler.propertyByName(name = descriptor.getName(), (BeanMetadata)bd)) != null && (value = propertyValue.getValue()) instanceof CollectionMetadata) {
            List values = ((CollectionMetadata)value).getValues();
            MutableCollectionMetadata newValue = (MutableCollectionMetadata)parserContext.createMetadata(MutableCollectionMetadata.class);
            for (Metadata v : values) {
                if (v instanceof ValueMetadata) {
                    newValue.addValue(QNameHelper.createQNameMetadata(element, ((ValueMetadata)v).getStringValue(), parserContext));
                    continue;
                }
                newValue.addValue(v);
            }
            bd.removeProperty(propertyValue);
            bd.addProperty(name, (Metadata)newValue);
        }
    }
}

