/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.bridge.internal;

import java.util.EventListener;
import java.util.Hashtable;
import javax.servlet.http.HttpServlet;
import org.apache.felix.http.base.internal.AbstractHttpActivator;
import org.apache.felix.http.base.internal.DispatcherServlet;
import org.apache.felix.http.base.internal.EventDispatcher;
import org.apache.felix.http.base.internal.logger.SystemLogger;

public final class BridgeActivator
extends AbstractHttpActivator {
    private static final String FELIX_HTTP_SERVICE_ENDPOINTS = "org.apache.felix.http.service.endpoints";
    private static final String VENDOR = "The Apache Software Foundation";
    private static final String MARKER_PROP = "http.felix.dispatcher";

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        DispatcherServlet servlet = this.getDispatcherServlet();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put(MARKER_PROP, ((Object)((Object)servlet)).getClass().getName());
        props.put("service.description", "Apache Felix Http Dispatcher for bridged request handling");
        props.put("service.vendor", VENDOR);
        this.getBundleContext().registerService(HttpServlet.class.getName(), (Object)servlet, props);
        EventDispatcher dispatcher = this.getEventDispatcher();
        dispatcher.setActive(true);
        props = new Hashtable();
        props.put(MARKER_PROP, dispatcher.getClass().getName());
        props.put("service.description", "Apache Felix Http Dispatcher for bridged event handling");
        props.put("service.vendor", VENDOR);
        this.getBundleContext().registerService(EventListener.class.getName(), (Object)dispatcher, props);
        if (this.getBundleContext().getProperty(FELIX_HTTP_SERVICE_ENDPOINTS) != null) {
            Hashtable<String, Object> serviceRegProps = new Hashtable<String, Object>();
            serviceRegProps.put("osgi.http.endpoint", this.getBundleContext().getProperty(FELIX_HTTP_SERVICE_ENDPOINTS));
            this.getHttpServiceController().setProperties(serviceRegProps);
        }
        SystemLogger.info("Started bridged http services");
    }
}

