/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.os;

import com.google.common.annotations.VisibleForTesting;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import org.apache.servicecomb.foundation.metrics.meter.PeriodMeter;
import org.apache.servicecomb.metrics.core.meter.os.NetMeter;
import org.apache.servicecomb.metrics.core.meter.os.SystemMeter;

public class OsMeter
implements PeriodMeter {
    public static final String OS_NAME = "os";
    public static final String OS_TYPE = "type";
    public static final String OS_TYPE_NET = "net";
    private final SystemMeter systemMeter;
    private final NetMeter netMeter;

    public OsMeter(MeterRegistry meterRegistry) {
        this.systemMeter = new SystemMeter(meterRegistry, OS_NAME);
        this.netMeter = new NetMeter(meterRegistry, OS_NAME, Tags.of((String)OS_TYPE, (String)OS_TYPE_NET));
    }

    public void poll(long msNow, long secondInterval) {
        this.systemMeter.poll(msNow, secondInterval);
        this.netMeter.poll(msNow, secondInterval);
    }

    @VisibleForTesting
    public SystemMeter getCpuMeter() {
        return this.systemMeter;
    }

    @VisibleForTesting
    public NetMeter getNetMeter() {
        return this.netMeter;
    }
}

