/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProviderFilter;
import org.apache.servicecomb.core.governance.MatchType;
import org.apache.servicecomb.governance.handler.MapperHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.governance.processor.mapping.Mapper;
import org.apache.servicecomb.swagger.invocation.Response;
import org.springframework.util.CollectionUtils;

public class ContextMapperFilter
extends AbstractFilter
implements ProviderFilter,
EdgeFilter {
    private final MapperHandler mapperHandler;

    public ContextMapperFilter(MapperHandler mapperHandler) {
        this.mapperHandler = mapperHandler;
    }

    @Override
    public boolean enabledForTransport(String transport) {
        return "rest".equals(transport);
    }

    @Override
    public int getOrder() {
        return -1995;
    }

    @Override
    public String getName() {
        return "context-mapper";
    }

    @Override
    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        GovernanceRequestExtractor request = MatchType.createGovHttpRequest(invocation);
        Mapper mapper = (Mapper)this.mapperHandler.getActuator(request);
        if (mapper == null || CollectionUtils.isEmpty((Map)mapper.target())) {
            return nextNode.onFilter(invocation);
        }
        Map properties = mapper.target();
        properties.forEach((k, v) -> {
            if (StringUtils.isEmpty((CharSequence)v)) {
                return;
            }
            if ("$U".equals(v)) {
                invocation.addContext((String)k, request.apiPath());
            } else if ("$M".equals(v)) {
                invocation.addContext((String)k, request.method());
            } else if (v.startsWith("$H{") && v.endsWith("}")) {
                invocation.addContext((String)k, request.header(v.substring(3, v.length() - 1)));
            } else if (v.startsWith("$Q{") && v.endsWith("}")) {
                invocation.addContext((String)k, request.query(v.substring(3, v.length() - 1)));
            } else {
                invocation.addContext((String)k, (String)v);
            }
        });
        return nextNode.onFilter(invocation);
    }
}

