/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.produce;

import com.fasterxml.jackson.databind.JavaType;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;

public class ProduceEventStreamProcessor
implements ProduceProcessor {
    private int writeIndex = 0;

    @Override
    public String getName() {
        return "text/event-stream";
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void doEncodeResponse(OutputStream output, Object result) throws Exception {
        String buffer = "id: " + this.writeIndex++ + "\ndata: " + RestObjectMapperFactory.getRestObjectMapper().writeValueAsString(result) + "\n\n";
        output.write(buffer.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Object doDecodeResponse(InputStream input, JavaType type) throws Exception {
        String buffer = new String(input.readAllBytes(), StandardCharsets.UTF_8);
        for (String line : buffer.split("\n")) {
            if (!line.startsWith("data: ")) continue;
            return RestObjectMapperFactory.getRestObjectMapper().readValue(line.substring(5), type);
        }
        return null;
    }
}

