/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.vertx;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.metrics.meter.AbstractPeriodMeter;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultEndpointMetric;
import org.apache.servicecomb.metrics.core.meter.vertx.EndpointMeter;

public class VertxEndpointsMeter
extends AbstractPeriodMeter {
    private final Map<String, DefaultEndpointMetric> endpointMetricMap;
    private final Map<String, EndpointMeter> endpointMeterMap = new ConcurrentHashMapEx();

    public <T extends DefaultEndpointMetric> VertxEndpointsMeter(Id id, Map<String, T> endpointMetricMap) {
        this.id = id;
        this.endpointMetricMap = endpointMetricMap;
    }

    public void calcMeasurements(long msNow, long secondInterval) {
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        this.calcMeasurements(measurements, msNow, secondInterval);
        this.allMeasurements = measurements;
    }

    public void calcMeasurements(List<Measurement> measurements, long msNow, long secondInterval) {
        this.syncMeters();
        for (EndpointMeter meter : this.endpointMeterMap.values()) {
            meter.calcMeasurements(measurements, msNow, secondInterval);
        }
    }

    private void syncMeters() {
        for (EndpointMeter meter : this.endpointMeterMap.values()) {
            if (this.endpointMetricMap.containsKey(meter.getMetric().getAddress())) continue;
            this.endpointMeterMap.remove(meter.getMetric().getAddress());
        }
        for (DefaultEndpointMetric metric : this.endpointMetricMap.values()) {
            this.endpointMeterMap.computeIfAbsent(metric.getAddress(), addr -> this.createEndpointMeter(this.id, metric));
        }
    }

    protected EndpointMeter createEndpointMeter(Id id, DefaultEndpointMetric metric) {
        return new EndpointMeter(id, metric);
    }

    public Iterable<Measurement> measure() {
        return this.allMeasurements;
    }

    public boolean hasExpired() {
        return false;
    }
}

