/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.invocation;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.List;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.invocation.InvocationStageTrace;
import org.apache.servicecomb.foundation.metrics.meter.SimpleTimer;
import org.apache.servicecomb.metrics.core.meter.invocation.ConsumerInvocationMeter;

public class EdgeInvocationMeter
extends ConsumerInvocationMeter {
    private final SimpleTimer executorQueueTimer = this.createStageTimer("queue");
    private final SimpleTimer serverFiltersRequestTimer = this.createStageTimer("server_filters_request");
    private final SimpleTimer serverFiltersResponseTimer = this.createStageTimer("server_filters_response");
    private final SimpleTimer sendResponseTimer = this.createStageTimer("producer_send_response");

    public EdgeInvocationMeter(Id id) {
        super(id);
    }

    @Override
    public void onInvocationFinish(InvocationFinishEvent event) {
        super.onInvocationFinish(event);
        InvocationStageTrace invocationStageTrace = event.getInvocation().getInvocationStageTrace();
        this.executorQueueTimer.record((long)invocationStageTrace.calcThreadPoolQueueTime());
        this.serverFiltersRequestTimer.record((long)invocationStageTrace.calcServerFiltersRequestTime());
        this.serverFiltersResponseTimer.record((long)invocationStageTrace.calcServerFiltersResponseTime());
        this.sendResponseTimer.record((long)invocationStageTrace.calcSendResponseTime());
    }

    @Override
    public void calcMeasurements(List<Measurement> measurements, long msNow, long secondInterval) {
        super.calcMeasurements(measurements, msNow, secondInterval);
        this.executorQueueTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.serverFiltersRequestTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.serverFiltersResponseTimer.calcMeasurements(measurements, msNow, secondInterval);
        this.sendResponseTimer.calcMeasurements(measurements, msNow, secondInterval);
    }
}

