/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.tools.unpack;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="unpack-resources", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class UnpackResourceMojo
extends AbstractMojo {
    private static final int KILOBYTE = 1024;
    private static final int MEGABYTE = 0x100000;
    private static final int BUFFER_MAX = 0x100000;
    @Parameter
    private String resource;
    @Parameter(defaultValue="${project.build.directory}/downloads")
    private File targetDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.resource == null) {
            throw new MojoExecutionException("Config parameter 'resource' required for this goal.");
        }
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.resource);
        if (is == null) {
            throw new MojoExecutionException("Could not find resource " + this.resource);
        }
        if (!this.targetDirectory.exists() && !this.targetDirectory.mkdirs()) {
            throw new MojoExecutionException("Could not create output directory " + this.targetDirectory.getPath());
        }
        byte[] data = new byte[0x100000];
        ArchiveInputStream archiveInputStream = null;
        try {
            ArchiveEntry entry;
            archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is));
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                File outputFile = new File(this.targetDirectory, entry.getName());
                if (entry.isDirectory()) {
                    if (outputFile.exists() || outputFile.mkdirs()) continue;
                    throw new MojoExecutionException("Could not create output directory " + outputFile.getAbsolutePath());
                }
                FileOutputStream fos = new FileOutputStream(outputFile);
                BufferedOutputStream dest = null;
                try {
                    int count;
                    dest = new BufferedOutputStream(fos, 0x100000);
                    while ((count = archiveInputStream.read(data, 0, 0x100000)) != -1) {
                        dest.write(data, 0, count);
                    }
                }
                finally {
                    if (dest == null) continue;
                    dest.flush();
                    dest.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Error unpacking resources", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error unpacking resources", (Exception)e);
        }
        catch (ArchiveException e) {
            throw new MojoExecutionException("Error unpacking resources", (Exception)((Object)e));
        }
        finally {
            if (archiveInputStream != null) {
                try {
                    archiveInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

