/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;

class LoggingSupport {
    private static final boolean isEnabled;
    private static final DateTimeFormatter timestampFormat;

    LoggingSupport() {
    }

    void withLogging(String apiName, Runnable code) {
        this.withLogging(apiName, () -> {
            code.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T withLogging(String apiName, Supplier<T> code) {
        T t;
        block4: {
            if (isEnabled) {
                LoggingSupport.logApi("=> " + apiName + " started");
            }
            boolean success = false;
            try {
                T result = code.get();
                success = true;
                t = result;
                if (!isEnabled) break block4;
                LoggingSupport.logApi("<= " + apiName + (success ? " succeeded" : " failed"));
            }
            catch (Throwable throwable) {
                if (isEnabled) {
                    LoggingSupport.logApi("<= " + apiName + (success ? " succeeded" : " failed"));
                }
                throw throwable;
            }
        }
        return t;
    }

    static void logWithTimestamp(String message) {
        String timestamp = ZonedDateTime.now().format(timestampFormat);
        System.err.println(timestamp + " " + message);
    }

    static void logApi(String message) {
        LoggingSupport.logWithTimestamp("pw:api " + message);
    }

    static {
        String debug = System.getenv("DEBUG");
        isEnabled = debug != null && debug.contains("pw:api");
        timestampFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").withZone(ZoneId.of("UTC"));
    }
}

