/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.NominalTypeBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;

public final class NominalTypeBuilderOti
implements NominalTypeBuilder {
    private final FunctionType constructor;
    private final ObjectType instance;
    private final ObjectType prototype;

    public NominalTypeBuilderOti(FunctionType constructor, ObjectType instance) {
        this.constructor = constructor;
        this.instance = instance;
        this.prototype = constructor.getPrototypeProperty();
    }

    @Override
    public void declarePrototypeProperty(String name, JSType type, Node defSite) {
        this.prototype.defineDeclaredProperty(name, type, defSite);
    }

    @Override
    public void declareInstanceProperty(String name, JSType type, Node defSite) {
        this.instance.defineDeclaredProperty(name, type, defSite);
    }

    @Override
    public void declareConstructorProperty(String name, JSType type, Node defSite) {
        this.constructor.defineDeclaredProperty(name, type, defSite);
    }

    @Override
    public NominalTypeBuilder superClass() {
        FunctionType ctor = this.instance.getSuperClassConstructor();
        if (ctor == null) {
            return null;
        }
        return new NominalTypeBuilderOti(ctor, ctor.getInstanceType());
    }

    @Override
    public FunctionType constructor() {
        return this.constructor;
    }

    @Override
    public ObjectType instance() {
        return this.instance;
    }

    @Override
    public ObjectType prototypeOrInstance() {
        return this.prototype;
    }
}

