/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.Utils;
import java.util.function.Supplier;

public class WaitForEventLogger<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private final ChannelOwner channel;
    private final String waitId;
    private final String apiName;

    WaitForEventLogger(ChannelOwner channelOwner, String apiName, Supplier<T> supplier) {
        this.supplier = supplier;
        this.channel = channelOwner;
        this.apiName = apiName;
        this.waitId = Utils.createGuid();
        JsonObject info = new JsonObject();
        info.addProperty("phase", "before");
        this.sendWaitForEventInfo(info);
    }

    @Override
    public T get() {
        JsonObject info = new JsonObject();
        info.addProperty("phase", "after");
        try {
            T t = this.supplier.get();
            return t;
        }
        catch (RuntimeException e) {
            info.addProperty("error", e.getMessage());
            throw e;
        }
        finally {
            this.sendWaitForEventInfo(info);
        }
    }

    private void sendWaitForEventInfo(JsonObject info) {
        info.addProperty("event", "");
        info.addProperty("waitId", this.waitId);
        JsonObject params = new JsonObject();
        params.add("info", (JsonElement)info);
        this.channel.withLogging(this.apiName, () -> this.channel.sendMessageAsync("waitForEventInfo", params));
    }
}

