/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class NoConstructorDispatchEventRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.FunctionCallID, (node, tokenQuery, problems) -> this.checkFunctionCallNode((IFunctionCallNode)node, tokenQuery, problems));
        return result;
    }

    private void checkFunctionCallNode(IFunctionCallNode functionCallNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        IFunctionNode functionNode = (IFunctionNode)functionCallNode.getAncestorOfType(IFunctionNode.class);
        if (functionNode == null || !functionNode.isConstructor()) {
            return;
        }
        IExpressionNode nameNode = functionCallNode.getNameNode();
        if (nameNode instanceof IIdentifierNode) {
            IIdentifierNode identifierNode = (IIdentifierNode)nameNode;
            if ("dispatchEvent".equals(identifierNode.getName())) {
                problems.add(new NoConstructorDispatchEventLinterProblem(functionNode, identifierNode));
                return;
            }
            return;
        }
        if (nameNode instanceof IMemberAccessExpressionNode) {
            ILanguageIdentifierNode langIdentifierNode;
            IIdentifierNode identifierNode;
            IMemberAccessExpressionNode memberAccess = (IMemberAccessExpressionNode)nameNode;
            if (memberAccess.getRightOperandNode() instanceof IIdentifierNode && "dispatchEvent".equals((identifierNode = (IIdentifierNode)memberAccess.getRightOperandNode()).getName()) && memberAccess.getLeftOperandNode() instanceof ILanguageIdentifierNode && (ILanguageIdentifierNode.LanguageIdentifierKind.THIS.equals((Object)(langIdentifierNode = (ILanguageIdentifierNode)memberAccess.getLeftOperandNode()).getKind()) || ILanguageIdentifierNode.LanguageIdentifierKind.SUPER.equals((Object)langIdentifierNode.getKind()))) {
                problems.add(new NoConstructorDispatchEventLinterProblem(functionNode, identifierNode));
                return;
            }
            return;
        }
    }

    public static class NoConstructorDispatchEventLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Constructor '${functionName}' must not call 'dispatchEvent'";
        public String functionName;

        public NoConstructorDispatchEventLinterProblem(IFunctionNode functionNode, IExpressionNode dispatchEventNode) {
            super((ISourceLocation)dispatchEventNode);
            this.functionName = functionNode.getName();
        }
    }
}

