/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.tools.debugger.Location;
import flash.tools.debugger.expression.ValueExp;
import flex.tools.debugger.cli.BreakIdentifier;
import flex.tools.debugger.cli.LocationCollection;
import java.util.Iterator;
import java.util.Vector;

public class BreakAction {
    public static final int RESOLVED = 1;
    public static final int UNRESOLVED = 2;
    public static final int AMBIGUOUS = 3;
    public static final int NOCODE = 4;
    private LocationCollection m_where;
    private String m_breakpointExpression;
    private Vector<String> m_commands;
    private boolean m_enabled;
    private boolean m_autoDelete;
    private boolean m_autoDisable;
    private boolean m_silent;
    private boolean m_singleSwf;
    private int m_id;
    private int m_hits;
    private ValueExp m_condition;
    private String m_conditionString;
    private int m_status;
    private boolean m_propagable;

    public BreakAction(LocationCollection locationCollection) throws NullPointerException {
        this.m_where = locationCollection;
        this.m_where.first().getFile();
        this.m_status = 1;
        this.init();
    }

    public BreakAction(String string) {
        this.m_breakpointExpression = string;
        this.m_status = 2;
        this.init();
    }

    private void init() {
        this.m_id = BreakIdentifier.next();
        this.m_commands = new Vector();
        this.m_propagable = true;
    }

    public int getCommandCount() {
        return this.m_commands.size();
    }

    public String commandAt(int n) {
        return this.m_commands.elementAt(n);
    }

    public Location getLocation() {
        return this.m_where != null ? this.m_where.first() : null;
    }

    public LocationCollection getLocations() {
        return this.m_where;
    }

    public int getId() {
        return this.m_id;
    }

    public int getHits() {
        return this.m_hits;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public boolean isAutoDisable() {
        return this.m_autoDisable;
    }

    public boolean isAutoDelete() {
        return this.m_autoDelete;
    }

    public boolean isSilent() {
        return this.m_silent;
    }

    public boolean isSingleSwf() {
        return this.m_singleSwf;
    }

    public ValueExp getCondition() {
        return this.m_condition;
    }

    public String getConditionString() {
        return this.m_conditionString;
    }

    public String getBreakpointExpression() {
        return this.m_breakpointExpression;
    }

    public int getStatus() {
        return this.m_status;
    }

    public boolean isPropagable() {
        return this.m_propagable;
    }

    public void addCommand(String string) {
        this.m_commands.add(string);
    }

    public void clearCommands() {
        this.m_commands.clear();
    }

    public void addLocation(Location location) {
        this.m_where.add(location);
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
    }

    public void setAutoDisable(boolean bl) {
        this.m_autoDisable = bl;
    }

    public void setAutoDelete(boolean bl) {
        this.m_autoDelete = bl;
    }

    public void setSilent(boolean bl) {
        this.m_silent = bl;
    }

    public void setCondition(ValueExp valueExp, String string) {
        this.m_condition = valueExp;
        this.m_conditionString = string;
    }

    public void clearCondition() {
        this.setCondition(null, "");
    }

    public void hit() {
        ++this.m_hits;
    }

    public void clearHits() {
        this.m_hits = 0;
    }

    public void setSingleSwf(boolean bl) {
        this.m_singleSwf = bl;
    }

    public void setBreakpointExpression(String string) {
        this.m_breakpointExpression = string;
    }

    public void setStatus(int n) {
        this.m_status = n;
    }

    public void setPropagable(boolean bl) {
        this.m_propagable = bl;
    }

    public void setLocations(LocationCollection locationCollection) {
        this.m_where = locationCollection;
        if (locationCollection != null) {
            this.setStatus(1);
        }
    }

    public boolean locationMatches(int n, int n2, int n3) {
        boolean bl = false;
        LocationCollection locationCollection = this.getLocations();
        if (locationCollection != null) {
            Iterator<Location> iterator = locationCollection.iterator();
            while (!bl && iterator.hasNext()) {
                Location location = iterator.next();
                if (location == null || location.getFile().getId() != n || location.getLine() != n2 || n3 != -1 && location.getIsolateId() != n3) continue;
                bl = true;
            }
        }
        return bl;
    }
}

