/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLBindingAttributeNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.problems.MXMLEmptyAttributeProblem;
import org.apache.royale.compiler.problems.MXMLRequiredAttributeProblem;
import org.apache.royale.compiler.problems.MXMLSameBindingSourceAndDestinationProblem;
import org.apache.royale.compiler.problems.MXMLSemanticProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLBindingAttributeNode;
import org.apache.royale.compiler.tree.mxml.IMXMLBindingNode;

public class MXMLBindingNode
extends MXMLNodeBase
implements IMXMLBindingNode {
    private IMXMLBindingAttributeNode[] children = null;
    private MXMLBindingAttributeNode sourceAttributeNode = null;
    private MXMLBindingAttributeNode destinationAttributeNode = null;
    private boolean twoWay = false;

    MXMLBindingNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLBindingID;
    }

    @Override
    public String getName() {
        return "Binding";
    }

    @Override
    public int getChildCount() {
        return this.children != null ? this.children.length : 0;
    }

    @Override
    public IASNode getChild(int i) {
        return this.children != null ? this.children[i] : null;
    }

    @Override
    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("source")) {
            this.sourceAttributeNode = new MXMLBindingAttributeNode(this);
            this.sourceAttributeNode.initializeFromAttribute(builder, attribute);
            info.addChildNode(this.sourceAttributeNode);
        } else if (attribute.isSpecialAttribute("destination")) {
            this.destinationAttributeNode = new MXMLBindingAttributeNode(this);
            this.destinationAttributeNode.initializeFromAttribute(builder, attribute);
            info.addChildNode(this.destinationAttributeNode);
        } else if (attribute.isSpecialAttribute("twoWay")) {
            String value = attribute.getMXMLDialect().trim(attribute.getRawValue());
            if (value.equals("true")) {
                this.twoWay = true;
            } else if (value.equals("false")) {
                this.twoWay = false;
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLSemanticProblem problem;
        super.initializationComplete(builder, tag, info);
        this.children = info.getChildNodeList().toArray(new IMXMLBindingAttributeNode[0]);
        RoyaleProject project = builder.getProject();
        builder.addExpressionDependency(project.getBindingManagerClass());
        IMXMLTagAttributeData sourceAttribute = tag.getTagAttributeData("source");
        IMXMLTagAttributeData destinationAttribute = tag.getTagAttributeData("destination");
        String trimmedSourceValue = null;
        String trimmedDestinationValue = null;
        if (sourceAttribute == null) {
            problem = new MXMLRequiredAttributeProblem(tag, "source");
            builder.addProblem(problem);
            this.markInvalidForCodeGen();
        } else {
            trimmedSourceValue = builder.getMXMLDialect().trim(sourceAttribute.getRawValue());
            if (trimmedSourceValue.isEmpty()) {
                problem = new MXMLEmptyAttributeProblem(sourceAttribute);
                builder.addProblem(problem);
                this.markInvalidForCodeGen();
            }
        }
        if (destinationAttribute == null) {
            problem = new MXMLRequiredAttributeProblem(tag, "destination");
            builder.addProblem(problem);
            this.markInvalidForCodeGen();
        } else {
            trimmedDestinationValue = builder.getMXMLDialect().trim(destinationAttribute.getRawValue());
            if (trimmedDestinationValue.isEmpty()) {
                problem = new MXMLEmptyAttributeProblem(destinationAttribute);
                builder.addProblem(problem);
                this.markInvalidForCodeGen();
            }
        }
        if (trimmedSourceValue != null && !trimmedSourceValue.isEmpty() && trimmedDestinationValue != null && !trimmedDestinationValue.isEmpty() && trimmedSourceValue.equals(trimmedDestinationValue)) {
            problem = new MXMLSameBindingSourceAndDestinationProblem(tag);
            builder.addProblem(problem);
            this.markInvalidForCodeGen();
        }
    }

    @Override
    public IMXMLBindingAttributeNode getSourceAttributeNode() {
        return this.sourceAttributeNode;
    }

    @Override
    public IMXMLBindingAttributeNode getDestinationAttributeNode() {
        return this.destinationAttributeNode;
    }

    @Override
    public boolean getTwoWay() {
        return this.twoWay;
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append("twoWay");
        sb.append('=');
        sb.append('\"');
        sb.append(this.twoWay);
        sb.append('\"');
        return true;
    }

    void setDestinationAttributeNode(MXMLBindingAttributeNode dest) {
        this.destinationAttributeNode = dest;
    }

    void setSourceAttributeNode(MXMLBindingAttributeNode src) {
        this.sourceAttributeNode = src;
    }
}

