/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs.reference;

import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.TemplatizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.royale.compiler.clients.ExternCConfiguration;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.BaseReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ClassReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ConstantReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.FunctionReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.MemberReference;
import org.apache.royale.compiler.internal.codegen.typedefs.utils.DebugLogUtils;

public class ReferenceModel {
    public ProblemQuery problems;
    private ExternCConfiguration configuration;
    private Compiler jscompiler;
    private List<String> namespaces = new ArrayList<String>();
    private HashMap<String, ClassReference> typedefs = new HashMap();
    private HashMap<String, ClassReference> classes = new HashMap();
    private HashMap<String, FunctionReference> functions = new HashMap();
    private HashMap<String, ConstantReference> constants = new HashMap();

    public void setJSCompiler(Compiler compiler) {
        this.jscompiler = compiler;
    }

    public ExternCConfiguration getConfiguration() {
        return this.configuration;
    }

    public ClassReference getObjectReference() {
        return this.classes.get("Object");
    }

    public Collection<String> getNamespaces() {
        return this.namespaces;
    }

    public Collection<ClassReference> getTypedefs() {
        return this.typedefs.values();
    }

    public Collection<ClassReference> getClasses() {
        return this.classes.values();
    }

    public Collection<FunctionReference> getFunctions() {
        return this.functions.values();
    }

    public Collection<ConstantReference> getConstants() {
        return this.constants.values();
    }

    public ReferenceModel(ExternCConfiguration config) {
        this.configuration = config;
    }

    public ClassReference getClassReference(String qualifiedName) {
        return this.classes.get(qualifiedName);
    }

    public ClassReference getInterfaceReference(String qualifiedName) {
        ClassReference reference = this.classes.get(qualifiedName);
        if (reference != null && reference.isInterface()) {
            return reference;
        }
        return null;
    }

    public ClassReference getTypeDefReference(String qualifiedName) {
        return this.typedefs.get(qualifiedName);
    }

    public void addNamespace(Node node, String qualifiedName) {
        if (this.namespaces.contains(qualifiedName)) {
            this.err("Duplicate namesapce [" + qualifiedName + "]");
            return;
        }
        this.log("Model.addNamespace(" + qualifiedName + ")");
        this.namespaces.add(qualifiedName);
    }

    public void addClass(Node node, String qualifiedName) {
        if (this.getConfiguration().isClassToFunctions(qualifiedName)) {
            this.addFunction(node, qualifiedName);
            return;
        }
        if (this.classes.containsKey(qualifiedName)) {
            this.err("Duplicate class [" + qualifiedName + "]");
            return;
        }
        this.log("Model.addClass(" + qualifiedName + ")");
        ClassReference reference = new ClassReference(this, node, qualifiedName);
        if (reference.getQualifiedName().equals("Object") || reference.getQualifiedName().equals("Class")) {
            reference.setDynamic(true);
        }
        this.classes.put(qualifiedName, reference);
    }

    public void addEnum(Node node, String qualifiedName) {
        if (this.classes.containsKey(qualifiedName)) {
            this.err("Duplicate class, @enum conflict [" + qualifiedName + "]");
            return;
        }
        this.log("Model.addEnum(" + qualifiedName + ")");
        ClassReference reference = new ClassReference(this, node, qualifiedName);
        this.classes.put(qualifiedName, reference);
    }

    public void addTypeDef(Node node, String qualifiedName) {
        if (this.typedefs.containsKey(qualifiedName)) {
            this.err("Duplicate @typedef [" + qualifiedName + "]");
            return;
        }
        this.log("Model.addTypeDef(" + qualifiedName + ")");
        ClassReference reference = new ClassReference(this, node, qualifiedName);
        this.typedefs.put(qualifiedName, reference);
    }

    public void addInterface(Node node, String qualifiedName) {
        if (this.classes.containsKey(qualifiedName)) {
            this.err("Duplicate @interface [" + qualifiedName + "]");
            return;
        }
        this.log("Model.addInterface(" + qualifiedName + ")");
        ClassReference reference = new ClassReference(this, node, qualifiedName);
        this.classes.put(qualifiedName, reference);
    }

    public void addFinalClass(Node node, String qualifiedName) {
        if (this.classes.containsKey(qualifiedName)) {
            this.err("Duplicate final class [" + qualifiedName + "]");
            return;
        }
        this.log("Model.addFinalClass(" + qualifiedName + ")");
        ClassReference reference = new ClassReference(this, node, qualifiedName);
        reference.setFinal(true);
        this.classes.put(qualifiedName, reference);
    }

    public void addFunction(Node node, String qualifiedName) {
        if (this.functions.containsKey(qualifiedName)) {
            this.err("Duplicate global function [" + qualifiedName + "]");
            return;
        }
        this.log("Model.addFunction(" + qualifiedName + ")");
        FunctionReference reference = new FunctionReference(this, node, qualifiedName, node.getJSDocInfo());
        this.functions.put(qualifiedName, reference);
    }

    public boolean hasFunction(String functionName) {
        return this.functions.containsKey(functionName);
    }

    public boolean hasClass(String className) {
        return this.classes.containsKey(className);
    }

    public boolean hasConstant(String qualifiedName) {
        return this.constants.containsKey(qualifiedName);
    }

    public void addConstant(Node node, String qualifiedName) {
        if (this.constants.containsKey(qualifiedName)) {
            return;
        }
        this.log("Model.addConstant(" + qualifiedName + ")");
        ConstantReference reference = new ConstantReference(this, node, qualifiedName, node.getJSDocInfo());
        this.constants.put(qualifiedName, reference);
    }

    public void addConstantType(Node node, String qualifiedName, JSType type) {
        if (this.constants.containsKey(qualifiedName)) {
            return;
        }
        this.log("Model.addConstantType(" + qualifiedName + ")");
        ConstantReference reference = new ConstantReference(this, node, qualifiedName, node.getJSDocInfo(), type);
        this.constants.put(qualifiedName, reference);
    }

    public void addField(Node node, String className, String memberName) {
        ClassReference classReference = this.getClassReference(className);
        if (classReference != null) {
            classReference.addField(node, memberName, node.getJSDocInfo(), false);
        }
    }

    public void addStaticField(Node node, String className, String memberName) {
        ClassReference classReference = this.getClassReference(className);
        JSDocInfo comment = NodeUtil.getBestJSDocInfo((Node)node);
        if (classReference != null) {
            classReference.addField(node, memberName, comment, true);
        } else {
            this.err(">>>> {ReferenceModel} Class [" + className + "] not found in " + node.getSourceFileName());
        }
    }

    public void addMethod(Node node, String className, String memberName) {
        JSDocInfo comment = NodeUtil.getBestJSDocInfo((Node)node);
        ClassReference classReference = this.getClassReference(className);
        if (classReference != null) {
            classReference.addMethod(node, memberName, comment, false);
        }
    }

    public void addStaticMethod(Node node, String className, String memberName) {
        ClassReference classReference = this.getClassReference(className);
        JSDocInfo comment = NodeUtil.getBestJSDocInfo((Node)node);
        if (classReference != null) {
            classReference.addMethod(node, memberName, comment, true);
        } else {
            this.err(">>>> {ReferenceModel} Class [" + className + "] not found in " + node.getSourceFileName());
        }
    }

    public final JSType evaluate(JSTypeExpression expression) {
        JSType jsType = null;
        if (expression != null) {
            try {
                jsType = expression.evaluate(null, this.jscompiler.getTypeRegistry());
                if (jsType.isTemplatizedType()) {
                    jsType = ((TemplatizedType)jsType).getReferencedType();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsType;
    }

    public ExternCConfiguration.ExcludedMember isExcludedClass(BaseReference classReference) {
        return this.getConfiguration().isExcludedClass(classReference);
    }

    public ExternCConfiguration.ExcludedMember isExcludedMember(ClassReference classReference, MemberReference memberReference) {
        return this.getConfiguration().isExcludedMember(classReference, memberReference);
    }

    public ExternCConfiguration.ReadOnlyMember isReadOnlyMember(ClassReference classReference, MemberReference memberReference) {
        return this.getConfiguration().isReadOnlyMember(classReference, memberReference);
    }

    protected void log(Node n) {
        DebugLogUtils.err(n);
    }

    protected void err(Node n) {
        DebugLogUtils.err(n);
    }

    protected void log(String message) {
        DebugLogUtils.log(message);
    }

    protected void err(String message) {
        DebugLogUtils.err(message);
    }

    public ExternCConfiguration.TrueConstant isTrueConstant(ClassReference classReference, MemberReference memberReference) {
        return this.getConfiguration().isTrueConstant(classReference, memberReference);
    }
}

