/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.broker.offset.ConsumerOffsetManager;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerListByGroupRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerListByGroupResponseBody;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerListByGroupResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryConsumerOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryConsumerOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.UpdateConsumerOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.UpdateConsumerOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.statictopic.LogicQueueMappingItem;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingContext;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingDetail;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingUtils;
import org.apache.rocketmq.remoting.rpc.RpcClientUtils;
import org.apache.rocketmq.remoting.rpc.RpcRequest;
import org.apache.rocketmq.remoting.rpc.RpcRequestHeader;
import org.apache.rocketmq.remoting.rpc.RpcResponse;
import org.apache.rocketmq.remoting.rpc.TopicRequestHeader;

public class ConsumerManageProcessor
implements NettyRequestProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerController brokerController;

    public ConsumerManageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        switch (request.getCode()) {
            case 38: {
                return this.getConsumerListByGroup(ctx, request);
            }
            case 15: {
                return this.updateConsumerOffset(ctx, request);
            }
            case 14: {
                return this.queryConsumerOffset(ctx, request);
            }
        }
        return null;
    }

    public boolean rejectRequest() {
        return false;
    }

    public RemotingCommand getConsumerListByGroup(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(GetConsumerListByGroupResponseHeader.class);
        GetConsumerListByGroupRequestHeader requestHeader = (GetConsumerListByGroupRequestHeader)request.decodeCommandCustomHeader(GetConsumerListByGroupRequestHeader.class);
        ConsumerGroupInfo consumerGroupInfo = this.brokerController.getConsumerManager().getConsumerGroupInfo(requestHeader.getConsumerGroup());
        if (consumerGroupInfo != null) {
            List<String> clientIds = consumerGroupInfo.getAllClientId();
            if (!clientIds.isEmpty()) {
                GetConsumerListByGroupResponseBody body = new GetConsumerListByGroupResponseBody();
                body.setConsumerIdList(clientIds);
                response.setBody(body.encode());
                response.setCode(0);
                response.setRemark(null);
                return response;
            }
            LOGGER.warn("getAllClientId failed, {} {}", (Object)requestHeader.getConsumerGroup(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        } else {
            LOGGER.warn("getConsumerGroupInfo failed, {} {}", (Object)requestHeader.getConsumerGroup(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        }
        response.setCode(1);
        response.setRemark("no consumer for this group, " + requestHeader.getConsumerGroup());
        return response;
    }

    public RemotingCommand rewriteRequestForStaticTopic(UpdateConsumerOffsetRequestHeader requestHeader, TopicQueueMappingContext mappingContext) {
        try {
            if (mappingContext.getMappingDetail() == null) {
                return null;
            }
            TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
            if (!mappingContext.isLeader()) {
                return RemotingCommand.buildErrorResponse((int)501, (String)String.format("%s-%d does not exit in request process of current broker %s", requestHeader.getTopic(), requestHeader.getQueueId(), mappingDetail.getBname()));
            }
            Long globalOffset = requestHeader.getCommitOffset();
            LogicQueueMappingItem mappingItem = TopicQueueMappingUtils.findLogicQueueMappingItem((List)mappingContext.getMappingItemList(), (long)globalOffset, (boolean)true);
            requestHeader.setQueueId(Integer.valueOf(mappingItem.getQueueId()));
            requestHeader.setLo(Boolean.valueOf(false));
            requestHeader.setBrokerName(mappingItem.getBname());
            requestHeader.setCommitOffset(Long.valueOf(mappingItem.computePhysicalQueueOffset(globalOffset.longValue())));
            if (mappingDetail.getBname().equals(mappingItem.getBname())) {
                return null;
            }
            RpcRequest rpcRequest = new RpcRequest(15, (RpcRequestHeader)requestHeader, null);
            RpcResponse rpcResponse = (RpcResponse)this.brokerController.getBrokerOuterAPI().getRpcClient().invoke(rpcRequest, this.brokerController.getBrokerConfig().getForwardTimeout()).get();
            if (rpcResponse.getException() != null) {
                throw rpcResponse.getException();
            }
            return RpcClientUtils.createCommandForRpcResponse((RpcResponse)rpcResponse);
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
    }

    private RemotingCommand updateConsumerOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        TopicQueueMappingContext mappingContext;
        RemotingCommand response = RemotingCommand.createResponseCommand(UpdateConsumerOffsetResponseHeader.class);
        UpdateConsumerOffsetRequestHeader requestHeader = (UpdateConsumerOffsetRequestHeader)request.decodeCommandCustomHeader(UpdateConsumerOffsetRequestHeader.class);
        RemotingCommand rewriteResult = this.rewriteRequestForStaticTopic(requestHeader, mappingContext = this.brokerController.getTopicQueueMappingManager().buildTopicQueueMappingContext((TopicRequestHeader)requestHeader));
        if (rewriteResult != null) {
            return rewriteResult;
        }
        String topic = requestHeader.getTopic();
        String group = requestHeader.getConsumerGroup();
        Integer queueId = requestHeader.getQueueId();
        Long offset = requestHeader.getCommitOffset();
        if (!this.brokerController.getSubscriptionGroupManager().containsSubscriptionGroup(group)) {
            response.setCode(26);
            response.setRemark("Group " + group + " not exist!");
            return response;
        }
        if (!this.brokerController.getTopicConfigManager().containsTopic(requestHeader.getTopic())) {
            response.setCode(17);
            response.setRemark("Topic " + topic + " not exist!");
            return response;
        }
        if (queueId == null) {
            response.setCode(29);
            response.setRemark("QueueId is null, topic is " + topic);
            return response;
        }
        if (offset == null) {
            response.setCode(29);
            response.setRemark("Offset is null, topic is " + topic);
            return response;
        }
        ConsumerOffsetManager consumerOffsetManager = this.brokerController.getConsumerOffsetManager();
        if (this.brokerController.getBrokerConfig().isUseServerSideResetOffset() && consumerOffsetManager.hasOffsetReset(topic, group, queueId)) {
            response.setCode(0);
            response.setRemark("Offset has been previously reset");
            LOGGER.info("Update consumer offset is rejected because of previous offset-reset. Group={}, Topic={}, QueueId={}, Offset={}", new Object[]{group, topic, queueId, offset});
            return response;
        }
        this.brokerController.getConsumerOffsetManager().commitOffset(RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), group, topic, queueId, offset);
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    public RemotingCommand rewriteRequestForStaticTopic(QueryConsumerOffsetRequestHeader requestHeader, TopicQueueMappingContext mappingContext) {
        try {
            if (mappingContext.getMappingDetail() == null) {
                return null;
            }
            TopicQueueMappingDetail mappingDetail = mappingContext.getMappingDetail();
            if (!mappingContext.isLeader()) {
                return RemotingCommand.buildErrorResponse((int)501, (String)String.format("%s-%d does not exit in request process of current broker %s", requestHeader.getTopic(), requestHeader.getQueueId(), mappingDetail.getBname()));
            }
            List mappingItemList = mappingContext.getMappingItemList();
            if (mappingItemList.size() == 1 && ((LogicQueueMappingItem)mappingItemList.get(0)).getLogicOffset() == 0L) {
                mappingContext.setCurrentItem((LogicQueueMappingItem)mappingItemList.get(0));
                requestHeader.setQueueId(Integer.valueOf(mappingContext.getLeaderItem().getQueueId()));
                return null;
            }
            List itemList = mappingContext.getMappingItemList();
            long offset = -1L;
            for (int i = itemList.size() - 1; i >= 0; --i) {
                LogicQueueMappingItem mappingItem = (LogicQueueMappingItem)itemList.get(i);
                mappingContext.setCurrentItem(mappingItem);
                if (mappingItem.getBname().equals(mappingDetail.getBname())) {
                    offset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getConsumerGroup(), requestHeader.getTopic(), mappingItem.getQueueId());
                    if (offset < 0L) continue;
                    break;
                }
                requestHeader.setBrokerName(mappingItem.getBname());
                requestHeader.setQueueId(Integer.valueOf(mappingItem.getQueueId()));
                requestHeader.setLo(Boolean.valueOf(false));
                requestHeader.setSetZeroIfNotFound(Boolean.valueOf(false));
                RpcRequest rpcRequest = new RpcRequest(14, (RpcRequestHeader)requestHeader, null);
                RpcResponse rpcResponse = (RpcResponse)this.brokerController.getBrokerOuterAPI().getRpcClient().invoke(rpcRequest, this.brokerController.getBrokerConfig().getForwardTimeout()).get();
                if (rpcResponse.getException() != null) {
                    throw rpcResponse.getException();
                }
                if (rpcResponse.getCode() == 0) {
                    offset = ((QueryConsumerOffsetResponseHeader)rpcResponse.getHeader()).getOffset();
                    break;
                }
                if (rpcResponse.getCode() == 22) continue;
                throw new RuntimeException("Unknown response code " + rpcResponse.getCode());
            }
            RemotingCommand response = RemotingCommand.createResponseCommand(QueryConsumerOffsetResponseHeader.class);
            QueryConsumerOffsetResponseHeader responseHeader = (QueryConsumerOffsetResponseHeader)response.readCustomHeader();
            if (offset >= 0L) {
                responseHeader.setOffset(Long.valueOf(offset));
                response.setCode(0);
                response.setRemark(null);
            } else {
                response.setCode(22);
                response.setRemark("Not found, maybe this group consumer boot first");
            }
            RemotingCommand rewriteResponseResult = this.rewriteResponseForStaticTopic(requestHeader, responseHeader, mappingContext, response.getCode());
            if (rewriteResponseResult != null) {
                return rewriteResponseResult;
            }
            return response;
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
    }

    public RemotingCommand rewriteResponseForStaticTopic(QueryConsumerOffsetRequestHeader requestHeader, QueryConsumerOffsetResponseHeader responseHeader, TopicQueueMappingContext mappingContext, int code) {
        try {
            if (mappingContext.getMappingDetail() == null) {
                return null;
            }
            if (code != 0) {
                return null;
            }
            LogicQueueMappingItem item = mappingContext.getCurrentItem();
            responseHeader.setOffset(Long.valueOf(item.computeStaticQueueOffsetStrictly(responseHeader.getOffset().longValue())));
            return null;
        }
        catch (Throwable t) {
            return RemotingCommand.buildErrorResponse((int)1, (String)t.getMessage());
        }
    }

    private RemotingCommand queryConsumerOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        TopicQueueMappingContext mappingContext;
        RemotingCommand response = RemotingCommand.createResponseCommand(QueryConsumerOffsetResponseHeader.class);
        QueryConsumerOffsetResponseHeader responseHeader = (QueryConsumerOffsetResponseHeader)response.readCustomHeader();
        QueryConsumerOffsetRequestHeader requestHeader = (QueryConsumerOffsetRequestHeader)request.decodeCommandCustomHeader(QueryConsumerOffsetRequestHeader.class);
        RemotingCommand rewriteResult = this.rewriteRequestForStaticTopic(requestHeader, mappingContext = this.brokerController.getTopicQueueMappingManager().buildTopicQueueMappingContext((TopicRequestHeader)requestHeader));
        if (rewriteResult != null) {
            return rewriteResult;
        }
        long offset = this.brokerController.getConsumerOffsetManager().queryOffset(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId());
        if (offset >= 0L) {
            responseHeader.setOffset(Long.valueOf(offset));
            response.setCode(0);
            response.setRemark(null);
        } else {
            long minOffset = this.brokerController.getMessageStore().getMinOffsetInQueue(requestHeader.getTopic(), requestHeader.getQueueId().intValue());
            if (requestHeader.getSetZeroIfNotFound() != null && Boolean.FALSE.equals(requestHeader.getSetZeroIfNotFound())) {
                response.setCode(22);
                response.setRemark("Not found, do not set to zero, maybe this group boot first");
            } else if (minOffset <= 0L && this.brokerController.getMessageStore().checkInMemByConsumeOffset(requestHeader.getTopic(), requestHeader.getQueueId().intValue(), 0L, 1)) {
                responseHeader.setOffset(Long.valueOf(0L));
                response.setCode(0);
                response.setRemark(null);
            } else {
                response.setCode(22);
                response.setRemark("Not found, V3_0_6_SNAPSHOT maybe this group consumer boot first");
            }
        }
        RemotingCommand rewriteResponseResult = this.rewriteResponseForStaticTopic(requestHeader, responseHeader, mappingContext, response.getCode());
        if (rewriteResponseResult != null) {
            return rewriteResponseResult;
        }
        return response;
    }
}

