/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.entity;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.closure.JoinableClosure;
import com.alipay.sofa.jraft.entity.LogEntry;
import com.alipay.sofa.jraft.util.Requires;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Task
implements Serializable {
    private static final long serialVersionUID = 2971309899898274575L;
    private ByteBuffer data = LogEntry.EMPTY_DATA;
    private Closure done;
    private long expectedTerm = -1L;

    public Task() {
    }

    public Task(ByteBuffer data, Closure done) {
        this.data = data;
        this.done = done;
    }

    public Task(ByteBuffer data, Closure done, long expectedTerm) {
        this.data = data;
        this.done = done;
        this.expectedTerm = expectedTerm;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer data) {
        Requires.requireNonNull(data, "data should not be null, you can use LogEntry.EMPTY_DATA instead.");
        this.data = data;
    }

    public Closure getDone() {
        return this.done;
    }

    public void setDone(Closure done) {
        this.done = done;
    }

    public long getExpectedTerm() {
        return this.expectedTerm;
    }

    public void setExpectedTerm(long expectedTerm) {
        this.expectedTerm = expectedTerm;
    }

    public Closure join() throws InterruptedException {
        JoinableClosure joinable = Task.castToJoinalbe(this.done);
        joinable.join();
        return joinable.getClosure();
    }

    public Closure join(long timeoutMillis) throws InterruptedException, TimeoutException {
        JoinableClosure joinable = Task.castToJoinalbe(this.done);
        joinable.join(timeoutMillis);
        return joinable.getClosure();
    }

    public static List<Closure> joinAll(List<Task> tasks) throws InterruptedException {
        ArrayList<Closure> closures = new ArrayList<Closure>(tasks.size());
        for (Task t : tasks) {
            closures.add(t.join());
        }
        return closures;
    }

    public static List<Closure> joinAll(List<Task> tasks, long timeoutMillis) throws InterruptedException, TimeoutException {
        ArrayList<Closure> closures = new ArrayList<Closure>(tasks.size());
        for (Task t : tasks) {
            long start = System.nanoTime();
            closures.add(t.join(timeoutMillis));
            if ((timeoutMillis -= TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)) > 0L) continue;
            throw new TimeoutException("joined timeout");
        }
        return closures;
    }

    private static JoinableClosure castToJoinalbe(Closure closure) {
        if (closure instanceof JoinableClosure) {
            return (JoinableClosure)closure;
        }
        throw new UnsupportedOperationException("Unsupported join");
    }
}

