/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.metadata.entity;

import com.alibaba.fastjson2.annotation.JSONField;
import java.util.Objects;

public class FileSegmentMetadata {
    public static final int STATUS_NEW = 0;
    public static final int STATUS_SEALED = 1;
    public static final int STATUS_DELETED = 2;
    @JSONField(ordinal=1)
    private String path;
    @JSONField(ordinal=2)
    private int type;
    @JSONField(ordinal=3)
    private long baseOffset;
    @JSONField(ordinal=4)
    private int status;
    @JSONField(ordinal=5)
    private long size;
    @JSONField(ordinal=6)
    private long createTimestamp;
    @JSONField(ordinal=7)
    private long beginTimestamp;
    @JSONField(ordinal=8)
    private long endTimestamp;
    @JSONField(ordinal=9)
    private long sealTimestamp;

    public FileSegmentMetadata() {
    }

    public FileSegmentMetadata(String path, long baseOffset, int type) {
        this.path = path;
        this.baseOffset = baseOffset;
        this.type = type;
        this.status = 0;
    }

    public void markSealed() {
        this.status = 1;
        this.sealTimestamp = System.currentTimeMillis();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getBaseOffset() {
        return this.baseOffset;
    }

    public void setBaseOffset(long baseOffset) {
        this.baseOffset = baseOffset;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(long createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public long getBeginTimestamp() {
        return this.beginTimestamp;
    }

    public void setBeginTimestamp(long beginTimestamp) {
        this.beginTimestamp = beginTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public void setEndTimestamp(long endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public long getSealTimestamp() {
        return this.sealTimestamp;
    }

    public void setSealTimestamp(long sealTimestamp) {
        this.sealTimestamp = sealTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSegmentMetadata metadata = (FileSegmentMetadata)o;
        return this.size == metadata.size && this.baseOffset == metadata.baseOffset && this.status == metadata.status && this.path.equals(metadata.path) && this.type == metadata.type && this.createTimestamp == metadata.createTimestamp && this.beginTimestamp == metadata.beginTimestamp && this.endTimestamp == metadata.endTimestamp && this.sealTimestamp == metadata.sealTimestamp;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.path, this.baseOffset, this.status, this.size, this.createTimestamp, this.beginTimestamp, this.endTimestamp, this.sealTimestamp);
    }
}

