/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl;

import io.openmessaging.storage.dledger.AppendFuture;
import io.openmessaging.storage.dledger.DLedgerConfig;
import io.openmessaging.storage.dledger.DLedgerLeaderElector;
import io.openmessaging.storage.dledger.DLedgerServer;
import io.openmessaging.storage.dledger.MemberState;
import io.openmessaging.storage.dledger.protocol.AppendEntryRequest;
import io.openmessaging.storage.dledger.protocol.BatchAppendEntryRequest;
import io.openmessaging.storage.dledger.statemachine.StateMachine;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.controller.Controller;
import org.apache.rocketmq.controller.elect.ElectPolicy;
import org.apache.rocketmq.controller.elect.impl.DefaultElectPolicy;
import org.apache.rocketmq.controller.impl.DLedgerControllerStateMachine;
import org.apache.rocketmq.controller.impl.event.ControllerResult;
import org.apache.rocketmq.controller.impl.event.EventMessage;
import org.apache.rocketmq.controller.impl.event.EventSerializer;
import org.apache.rocketmq.controller.impl.manager.ReplicasInfoManager;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.RemotingServer;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.SyncStateSet;
import org.apache.rocketmq.remoting.protocol.header.controller.AlterSyncStateSetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.CleanControllerBrokerDataRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetMetaDataResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.RegisterBrokerToControllerRequestHeader;

public class DLedgerController
implements Controller {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqController");
    private final DLedgerServer dLedgerServer;
    private final ControllerConfig controllerConfig;
    private final DLedgerConfig dLedgerConfig;
    private final ReplicasInfoManager replicasInfoManager;
    private final EventScheduler scheduler;
    private final EventSerializer eventSerializer;
    private final RoleChangeHandler roleHandler;
    private final DLedgerControllerStateMachine statemachine;
    private BiPredicate<String, String> brokerAlivePredicate;
    private ElectPolicy electPolicy;
    private AtomicBoolean isScheduling = new AtomicBoolean(false);

    public DLedgerController(ControllerConfig config, BiPredicate<String, String> brokerAlivePredicate) {
        this(config, brokerAlivePredicate, null, null, null, null);
    }

    public DLedgerController(ControllerConfig controllerConfig, BiPredicate<String, String> brokerAlivePredicate, NettyServerConfig nettyServerConfig, NettyClientConfig nettyClientConfig, ChannelEventListener channelEventListener, ElectPolicy electPolicy) {
        this.controllerConfig = controllerConfig;
        this.eventSerializer = new EventSerializer();
        this.scheduler = new EventScheduler();
        this.brokerAlivePredicate = brokerAlivePredicate;
        this.electPolicy = electPolicy == null ? new DefaultElectPolicy() : electPolicy;
        this.dLedgerConfig = new DLedgerConfig();
        this.dLedgerConfig.setGroup(controllerConfig.getControllerDLegerGroup());
        this.dLedgerConfig.setPeers(controllerConfig.getControllerDLegerPeers());
        this.dLedgerConfig.setSelfId(controllerConfig.getControllerDLegerSelfId());
        this.dLedgerConfig.setStoreBaseDir(controllerConfig.getControllerStorePath());
        this.dLedgerConfig.setMappedFileSizeForEntryData(controllerConfig.getMappedFileSize());
        this.roleHandler = new RoleChangeHandler(this.dLedgerConfig.getSelfId());
        this.replicasInfoManager = new ReplicasInfoManager(controllerConfig);
        this.statemachine = new DLedgerControllerStateMachine(this.replicasInfoManager, this.eventSerializer, this.dLedgerConfig.getSelfId());
        this.dLedgerServer = new DLedgerServer(this.dLedgerConfig, nettyServerConfig, nettyClientConfig, channelEventListener);
        this.dLedgerServer.registerStateMachine((StateMachine)this.statemachine);
        this.dLedgerServer.getDLedgerLeaderElector().addRoleChangeHandler((DLedgerLeaderElector.RoleChangeHandler)this.roleHandler);
    }

    @Override
    public void startup() {
        this.dLedgerServer.startup();
    }

    @Override
    public void shutdown() {
        this.dLedgerServer.shutdown();
    }

    @Override
    public void startScheduling() {
        if (this.isScheduling.compareAndSet(false, true)) {
            log.info("Start scheduling controller events");
            this.scheduler.start();
        }
    }

    @Override
    public void stopScheduling() {
        if (this.isScheduling.compareAndSet(true, false)) {
            log.info("Stop scheduling controller events");
            this.scheduler.shutdown(true);
        }
    }

    @Override
    public boolean isLeaderState() {
        return this.roleHandler.isLeaderState();
    }

    public ControllerConfig getControllerConfig() {
        return this.controllerConfig;
    }

    @Override
    public CompletableFuture<RemotingCommand> alterSyncStateSet(AlterSyncStateSetRequestHeader request, SyncStateSet syncStateSet) {
        return this.scheduler.appendEvent("alterSyncStateSet", () -> this.replicasInfoManager.alterSyncStateSet(request, syncStateSet, this.brokerAlivePredicate), true);
    }

    @Override
    public CompletableFuture<RemotingCommand> electMaster(ElectMasterRequestHeader request) {
        return this.scheduler.appendEvent("electMaster", () -> this.replicasInfoManager.electMaster(request, this.electPolicy), true);
    }

    @Override
    public CompletableFuture<RemotingCommand> registerBroker(RegisterBrokerToControllerRequestHeader request) {
        return this.scheduler.appendEvent("registerBroker", () -> this.replicasInfoManager.registerBroker(request, this.brokerAlivePredicate), true);
    }

    @Override
    public CompletableFuture<RemotingCommand> getReplicaInfo(GetReplicaInfoRequestHeader request) {
        return this.scheduler.appendEvent("getReplicaInfo", () -> this.replicasInfoManager.getReplicaInfo(request), false);
    }

    @Override
    public CompletableFuture<RemotingCommand> getSyncStateData(List<String> brokerNames) {
        return this.scheduler.appendEvent("getSyncStateData", () -> this.replicasInfoManager.getSyncStateData(brokerNames), false);
    }

    @Override
    public RemotingCommand getControllerMetadata() {
        MemberState state = this.getMemberState();
        Map peers = state.getPeerMap();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : peers.entrySet()) {
            String peer = (String)entry.getKey() + ":" + (String)entry.getValue();
            sb.append(peer).append(";");
        }
        return RemotingCommand.createResponseCommandWithHeader((int)0, (CommandCustomHeader)new GetMetaDataResponseHeader(state.getGroup(), state.getLeaderId(), state.getLeaderAddr(), state.isLeader(), sb.toString()));
    }

    @Override
    public RemotingServer getRemotingServer() {
        return this.dLedgerServer.getRemotingServer();
    }

    @Override
    public CompletableFuture<RemotingCommand> cleanBrokerData(CleanControllerBrokerDataRequestHeader requestHeader) {
        return this.scheduler.appendEvent("cleanBrokerData", () -> this.replicasInfoManager.cleanBrokerData(requestHeader, this.brokerAlivePredicate), true);
    }

    private boolean appendToDLedgerAndWait(AppendEntryRequest request) throws Throwable {
        if (request != null) {
            request.setGroup(this.dLedgerConfig.getGroup());
            request.setRemoteId(this.dLedgerConfig.getSelfId());
            AppendFuture dLedgerFuture = (AppendFuture)this.dLedgerServer.handleAppend(request);
            if (dLedgerFuture.getPos() == -1L) {
                return false;
            }
            dLedgerFuture.get(5L, TimeUnit.SECONDS);
            return true;
        }
        return false;
    }

    public MemberState getMemberState() {
        return this.dLedgerServer.getMemberState();
    }

    public void setBrokerAlivePredicate(BiPredicate<String, String> brokerAlivePredicate) {
        this.brokerAlivePredicate = brokerAlivePredicate;
    }

    public void setElectPolicy(ElectPolicy electPolicy) {
        this.electPolicy = electPolicy;
    }

    class RoleChangeHandler
    implements DLedgerLeaderElector.RoleChangeHandler {
        private final String selfId;
        private final ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)new ThreadFactoryImpl("DLedgerControllerRoleChangeHandler_"));
        private volatile MemberState.Role currentRole = MemberState.Role.FOLLOWER;

        public RoleChangeHandler(String selfId) {
            this.selfId = selfId;
        }

        public void handle(long term, MemberState.Role role) {
            Runnable runnable = () -> {
                block1 : switch (role) {
                    case CANDIDATE: {
                        this.currentRole = MemberState.Role.CANDIDATE;
                        log.info("Controller {} change role to candidate", (Object)this.selfId);
                        DLedgerController.this.stopScheduling();
                        break;
                    }
                    case FOLLOWER: {
                        this.currentRole = MemberState.Role.FOLLOWER;
                        log.info("Controller {} change role to Follower, leaderId:{}", (Object)this.selfId, (Object)DLedgerController.this.getMemberState().getLeaderId());
                        DLedgerController.this.stopScheduling();
                        break;
                    }
                    case LEADER: {
                        log.info("Controller {} change role to leader, try process a initial proposal", (Object)this.selfId);
                        int tryTimes = 0;
                        while (true) {
                            AppendEntryRequest request = new AppendEntryRequest();
                            request.setBody(new byte[0]);
                            try {
                                if (DLedgerController.this.appendToDLedgerAndWait(request)) {
                                    this.currentRole = MemberState.Role.LEADER;
                                    DLedgerController.this.startScheduling();
                                    break block1;
                                }
                            }
                            catch (Throwable e) {
                                log.error("Error happen when controller leader append initial request to DLedger", e);
                            }
                            if (!DLedgerController.this.getMemberState().isLeader()) {
                                log.error("Append a initial log failed because current state is not leader");
                                break block1;
                            }
                            log.error(String.format("Controller leader append initial log failed, try %d times", ++tryTimes));
                            if (tryTimes % 3 != 0) continue;
                            log.warn("Controller leader append initial log failed too many times, please wait a while");
                        }
                    }
                }
            };
            this.executorService.submit(runnable);
        }

        public void startup() {
        }

        public void shutdown() {
            if (this.currentRole == MemberState.Role.LEADER) {
                DLedgerController.this.stopScheduling();
            }
            this.executorService.shutdown();
        }

        public boolean isLeaderState() {
            return this.currentRole == MemberState.Role.LEADER;
        }
    }

    class ControllerEventHandler<T>
    implements EventHandler<T> {
        private final String name;
        private final Supplier<ControllerResult<T>> supplier;
        private final CompletableFuture<RemotingCommand> future;
        private final boolean isWriteEvent;

        ControllerEventHandler(String name, Supplier<ControllerResult<T>> supplier, boolean isWriteEvent) {
            this.name = name;
            this.supplier = supplier;
            this.future = new CompletableFuture();
            this.isWriteEvent = isWriteEvent;
        }

        @Override
        public void run() throws Throwable {
            ControllerResult<T> result = this.supplier.get();
            log.info("Event queue run event {}, get the result {}", (Object)this.name, result);
            boolean appendSuccess = true;
            if (!this.isWriteEvent || result.getEvents() == null || result.getEvents().isEmpty()) {
                if (DLedgerController.this.controllerConfig.isProcessReadEvent()) {
                    AppendEntryRequest request = new AppendEntryRequest();
                    request.setBody(new byte[0]);
                    appendSuccess = DLedgerController.this.appendToDLedgerAndWait(request);
                }
            } else {
                List<EventMessage> events = result.getEvents();
                ArrayList<byte[]> eventBytes = new ArrayList<byte[]>(events.size());
                for (EventMessage event : events) {
                    byte[] data;
                    if (event == null || (data = DLedgerController.this.eventSerializer.serialize(event)) == null || data.length <= 0) continue;
                    eventBytes.add(data);
                }
                if (!eventBytes.isEmpty()) {
                    BatchAppendEntryRequest request = new BatchAppendEntryRequest();
                    request.setBatchMsgs(eventBytes);
                    appendSuccess = DLedgerController.this.appendToDLedgerAndWait((AppendEntryRequest)request);
                }
            }
            if (appendSuccess) {
                RemotingCommand response = RemotingCommand.createResponseCommandWithHeader((int)result.getResponseCode(), (CommandCustomHeader)((CommandCustomHeader)result.getResponse()));
                if (result.getBody() != null) {
                    response.setBody(result.getBody());
                }
                if (result.getRemark() != null) {
                    response.setRemark(result.getRemark());
                }
                this.future.complete(response);
            } else {
                log.error("Failed to append event to DLedger, the response is {}, try cancel the future", result.getResponse());
                this.future.cancel(true);
            }
        }

        @Override
        public CompletableFuture<RemotingCommand> future() {
            return this.future;
        }

        @Override
        public void handleException(Throwable t) {
            log.error("Error happen when handle event {}", (Object)this.name, (Object)t);
            this.future.completeExceptionally(t);
        }
    }

    class EventScheduler
    extends ServiceThread {
        private final BlockingQueue<EventHandler> eventQueue = new LinkedBlockingQueue<EventHandler>(1024);

        public String getServiceName() {
            return EventScheduler.class.getName();
        }

        public void run() {
            log.info("Start event scheduler.");
            while (!this.isStopped()) {
                EventHandler handler;
                try {
                    handler = this.eventQueue.poll(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    continue;
                }
                try {
                    if (handler == null) continue;
                    handler.run();
                }
                catch (Throwable e) {
                    handler.handleException(e);
                }
            }
        }

        public <T> CompletableFuture<RemotingCommand> appendEvent(String name, Supplier<ControllerResult<T>> supplier, boolean isWriteEvent) {
            if (this.isStopped() || !DLedgerController.this.roleHandler.isLeaderState()) {
                RemotingCommand command = RemotingCommand.createResponseCommand((int)2007, (String)"The controller is not in leader state");
                CompletableFuture<RemotingCommand> future = new CompletableFuture<RemotingCommand>();
                future.complete(command);
                return future;
            }
            ControllerEventHandler<T> event = new ControllerEventHandler<T>(name, supplier, isWriteEvent);
            int tryTimes = 0;
            while (true) {
                try {
                    while (!this.eventQueue.offer(event, 5L, TimeUnit.SECONDS)) {
                    }
                    return event.future();
                }
                catch (InterruptedException e) {
                    log.error("Error happen in EventScheduler when append event", (Throwable)e);
                    if (++tryTimes <= 3) continue;
                    return null;
                }
                break;
            }
        }
    }

    static interface EventHandler<T> {
        public void run() throws Throwable;

        public CompletableFuture<RemotingCommand> future();

        public void handleException(Throwable var1);
    }
}

