/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class FileRegionEncoder
extends MessageToByteEncoder<FileRegion> {
    protected void encode(ChannelHandlerContext ctx, FileRegion msg, final ByteBuf out) throws Exception {
        long transferred;
        WritableByteChannel writableByteChannel = new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) {
                int prev = out.writerIndex();
                out.writeBytes(src);
                return out.writerIndex() - prev;
            }

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() throws IOException {
            }
        };
        long toTransfer = msg.count();
        while (toTransfer - (transferred = msg.transfered()) > 0L) {
            msg.transferTo(writableByteChannel, transferred);
        }
    }
}

