/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.List;
import javax.net.ssl.TrustManager;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.CertificateDetails;

@ManagedObject(defaultType="FileTrustStore")
public interface TrustStore<X extends TrustStore<X>>
extends ConfiguredObject<X> {
    public static final String TRUST_ANCHOR_VALIDITY_ENFORCED = "trustAnchorValidityEnforced";
    public static final String CERTIFICATE_EXPIRY_WARN_PERIOD = "qpid.truststore.certificateExpiryWarnPeriod";
    @ManagedContextDefault(name="qpid.truststore.certificateExpiryWarnPeriod", description="The number of days before a certificate's expiry that certificate expiration warnings will be written to the log")
    public static final int DEFAULT_CERTIFICATE_EXPIRY_WARN_PERIOD = 30;
    public static final String CERTIFICATE_EXPIRY_CHECK_FREQUENCY = "qpid.truststore.certificateExpiryCheckFrequency";
    @ManagedContextDefault(name="qpid.truststore.certificateExpiryCheckFrequency", description="Period (in days) with which the Broker will repeat the certificate expiration warning")
    public static final int DEFAULT_CERTIFICATE_EXPIRY_CHECK_FREQUENCY = 1;
    @ManagedContextDefault(name="qpid.truststore.trustAnchorValidityEnforced")
    public static final boolean DEFAULT_TRUST_ANCHOR_VALIDITY_ENFORCED = false;
    public static final String CERTIFICATE_REVOCATION_CHECK_ENABLED = "certificateRevocationCheckEnabled";
    public static final String CERTIFICATE_REVOCATION_CHECK_WITH_IGNORING_SOFT_FAILURES = "certificateRevocationCheckWithIgnoringSoftFailures";
    public static final String CERTIFICATE_REVOCATION_CHECK_WITH_PREFERRING_CERTIFICATE_REVOCATION_LIST = "certificateRevocationCheckWithPreferringCertificateRevocationList";
    public static final String CERTIFICATE_REVOCATION_CHECK_WITH_NO_FALLBACK = "certificateRevocationCheckWithNoFallback";
    public static final String CERTIFICATE_REVOCATION_CHECK_OF_ONLY_END_ENTITY_CERTIFICATES = "certificateRevocationCheckOfOnlyEndEntityCertificates";
    public static final String CERTIFICATE_REVOCATION_LIST_URL = "certificateRevocationListUrl";

    @Override
    @ManagedAttribute(immutable=true)
    public String getName();

    @ManagedAttribute(defaultValue="false", description="If true the Trust Store will expose its certificates as a special artificial message source.")
    public boolean isExposedAsMessageSource();

    @ManagedAttribute(defaultValue="[]", description="If 'exposedAsMessageSource' is true, the trust store will expose its certificates only to VirtualHostNodes in this list or if this list is empty to all VirtualHostNodes who are not in the 'excludedVirtualHostNodeMessageSources' list.")
    public List<VirtualHostNode<?>> getIncludedVirtualHostNodeMessageSources();

    @ManagedAttribute(defaultValue="[]", description="If 'exposedAsMessageSource' is true and 'includedVirtualHostNodeMessageSources' is empty, the trust store will expose its certificates only to VirtualHostNodes who are not in this list.")
    public List<VirtualHostNode<?>> getExcludedVirtualHostNodeMessageSources();

    @ManagedAttribute(defaultValue="${qpid.truststore.trustAnchorValidityEnforced}", description="If true, the trust anchor's validity dates will be enforced.")
    public boolean isTrustAnchorValidityEnforced();

    @ManagedAttribute(defaultValue="false", description="If true, enable certificates revocation.")
    public boolean isCertificateRevocationCheckEnabled();

    @ManagedAttribute(defaultValue="false", description="If true, check the revocation status of only end-entity certificates.")
    public boolean isCertificateRevocationCheckOfOnlyEndEntityCertificates();

    @ManagedAttribute(defaultValue="true", description="If true, prefer CRL (specified in certificate distribution points) to OCSP, if false prefer OCSP to CRL.")
    public boolean isCertificateRevocationCheckWithPreferringCertificateRevocationList();

    @ManagedAttribute(defaultValue="true", description="If true, disable fallback to CRL/OCSP (if 'certificateRevocationCheckWithPreferringCertificateRevocationList' set to true, disable fallback to OCSP, otherwise disable fallback to CRL in certificate distribution points).")
    public boolean isCertificateRevocationCheckWithNoFallback();

    @ManagedAttribute(defaultValue="false", description="If true, revocation check will succeed if CRL/OCSP response cannot be obtained because of network error or OCSP responder returns internalError or tryLater.")
    public boolean isCertificateRevocationCheckWithIgnoringSoftFailures();

    @ManagedAttribute(oversize=true, description="If set, certificates will be validated only against CRL file (CRL in distribution points and OCSP will be ignored).", oversizedAltText="Value is too long to display")
    public String getCertificateRevocationListUrl();

    @DerivedAttribute
    public String getCertificateRevocationListPath();

    @DerivedAttribute(description="List of details about the certificates like validity dates, SANs, issuer and subject names, etc.")
    public List<CertificateDetails> getCertificateDetails();

    @DerivedAttribute
    public int getCertificateExpiryWarnPeriod();

    @DerivedAttribute
    public int getCertificateExpiryCheckFrequency();

    public TrustManager[] getTrustManagers() throws GeneralSecurityException;

    public Certificate[] getCertificates() throws GeneralSecurityException;
}

