/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.arbiter.impl;

import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.rep.arbiter.impl.ArbiterStatDefinition;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class ArbiterVLSNTracker {
    private static final int VERSION = 1;
    private RandomAccessFile raf;
    private final File dataFile;
    private VLSN currentVLSN = VLSN.NULL_VLSN;
    private volatile VLSN dtvlsn = VLSN.NULL_VLSN;
    private final int VERSION_OFFSET = 0;
    private final int NODEID_OFFSET = 32;
    private final int DATA_OFFSET = 64;
    private int nodeId = -1;
    private final StatGroup stats;
    private final LongStat nWrites;
    private final LongStat nFSyncs;
    private final LongStat vlsnStat;
    private final LongStat dtVlsnStat;

    ArbiterVLSNTracker(File file) {
        this.dataFile = file;
        boolean fileExists = this.dataFile.exists();
        this.stats = new StatGroup("ArbFileIO", "Arbiter file I/O statistics");
        this.nFSyncs = new LongStat(this.stats, ArbiterStatDefinition.ARB_N_FSYNCS);
        this.nWrites = new LongStat(this.stats, ArbiterStatDefinition.ARB_N_WRITES);
        this.vlsnStat = new LongStat(this.stats, ArbiterStatDefinition.ARB_VLSN);
        this.dtVlsnStat = new LongStat(this.stats, ArbiterStatDefinition.ARB_DTVLSN);
        try {
            this.raf = new RandomAccessFile(this.dataFile, "rw");
            if (fileExists) {
                int readVersion = this.readVersion();
                if (readVersion > 1) {
                    throw new RuntimeException("Arbiter data file does not have a supported version field " + this.dataFile.getAbsolutePath());
                }
                this.nodeId = this.readNodeId();
                if (this.raf.length() > 64L) {
                    this.raf.seek(64L);
                    this.currentVLSN = new VLSN(this.raf.readLong());
                    this.dtvlsn = new VLSN(this.raf.readLong());
                }
            } else {
                this.writeVersion(1);
                this.writeNodeIdInternal(this.nodeId);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read the Arbiter data file " + this.dataFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to open the Arbiter data file " + this.dataFile.getAbsolutePath() + " exception " + e.getMessage());
        }
    }

    public StatGroup loadStats(StatsConfig config) {
        this.vlsnStat.set(this.get().getSequence());
        this.dtVlsnStat.set(this.getDTVLSN().getSequence());
        return this.stats.cloneGroup(config.getClear());
    }

    public synchronized void writeNodeId(int id) {
        if (this.nodeId == id) {
            return;
        }
        this.writeNodeIdInternal(id);
    }

    public synchronized int getCachedNodeId() {
        return this.nodeId;
    }

    private void writeNodeIdInternal(int id) {
        if (this.raf == null) {
            throw new RuntimeException("Internal error: Unable to write the Arbiter data file  because the file is not open." + this.dataFile.getAbsolutePath());
        }
        try {
            this.raf.seek(32L);
            this.raf.writeInt(id);
            this.nWrites.increment();
            this.doFSync();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write the Arbiter data file " + this.dataFile.getAbsolutePath());
        }
    }

    private int readNodeId() {
        if (this.raf == null) {
            throw new RuntimeException("Internal error: Unable to read the Arbiter data file  because the file is not open." + this.dataFile.getAbsolutePath());
        }
        try {
            this.raf.seek(32L);
            return this.raf.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read the Arbiter data file " + this.dataFile.getAbsolutePath());
        }
    }

    public synchronized void writeVersion(int id) {
        if (this.raf == null) {
            throw new RuntimeException("Internal error: Unable to write the Arbiter data file  because the file is not open." + this.dataFile.getAbsolutePath());
        }
        if (this.nodeId == id) {
            return;
        }
        try {
            this.raf.seek(0L);
            this.raf.writeInt(id);
            this.nWrites.increment();
            this.doFSync();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write the Arbiter data file " + this.dataFile.getAbsolutePath());
        }
    }

    private int readVersion() {
        if (this.raf == null) {
            throw new RuntimeException("Internal error: Unable to read the Arbiter data file  because the file is not open." + this.dataFile.getAbsolutePath());
        }
        try {
            this.raf.seek(0L);
            return this.raf.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write the Arbiter data file " + this.dataFile.getAbsolutePath());
        }
    }

    public synchronized void write(VLSN nextCurrentVLSN, VLSN nextDTVLSN, boolean doFSync) {
        if (this.raf == null) {
            throw new RuntimeException("Internal error: Unable to write the Arbiter data file  because the file is not open." + this.dataFile.getAbsolutePath());
        }
        if (nextCurrentVLSN.compareTo(this.currentVLSN) > 0) {
            this.currentVLSN = nextCurrentVLSN;
            this.dtvlsn = nextDTVLSN;
            try {
                this.raf.seek(64L);
                this.raf.writeLong(nextCurrentVLSN.getSequence());
                this.raf.writeLong(nextDTVLSN.getSequence());
                this.nWrites.add(2L);
                if (doFSync) {
                    this.doFSync();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write the Arbiter data file " + this.dataFile.getAbsolutePath());
            }
        }
    }

    public synchronized void close() {
        if (this.raf != null) {
            try {
                this.doFSync();
                this.raf.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.raf = null;
            }
        }
    }

    public VLSN get() {
        return this.currentVLSN;
    }

    public VLSN getDTVLSN() {
        return this.dtvlsn;
    }

    public static StatGroup loadEmptyStats() {
        StatGroup tmpStats = new StatGroup("ArbFileIO", "Arbiter file I/O statistics");
        new LongStat(tmpStats, ArbiterStatDefinition.ARB_N_FSYNCS);
        new LongStat(tmpStats, ArbiterStatDefinition.ARB_N_WRITES);
        new LongStat(tmpStats, ArbiterStatDefinition.ARB_VLSN);
        new LongStat(tmpStats, ArbiterStatDefinition.ARB_DTVLSN);
        return tmpStats;
    }

    private void doFSync() throws IOException {
        if (this.raf == null) {
            return;
        }
        this.raf.getFD().sync();
        this.nFSyncs.increment();
    }
}

