/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.io.Serializable;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.pluto.container.bean.processor.PortletSessionScopedBeanMap;
import org.apache.pluto.container.bean.processor.PortletSessionScopedConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletSessionBeanHolder
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(PortletSessionBeanHolder.class);
    private static final boolean isTrace = LOG.isTraceEnabled();
    private static final long serialVersionUID = 4713451590109713169L;
    private static final String ATTRIBNAME = "portletSessionBeanHolder";
    private static final ThreadLocal<PortletSessionBeanHolder> holders = new ThreadLocal();
    private final PortletSessionScopedBeanMap beans;
    private final PortletSessionScopedConfig config;
    private final String windowId;

    private PortletSessionBeanHolder(PortletSessionScopedBeanMap beans, String windowId, PortletSessionScopedConfig config) {
        this.beans = beans;
        this.windowId = windowId;
        this.config = config;
    }

    public static void setBeanHolder(PortletRequest req, PortletSessionScopedConfig config) {
        PortletSession ps = req.getPortletSession();
        String windowId = req.getWindowID();
        PortletSessionScopedBeanMap map = (PortletSessionScopedBeanMap)ps.getAttribute(ATTRIBNAME, 1);
        boolean createdMap = false;
        if (map == null) {
            map = new PortletSessionScopedBeanMap();
            ps.setAttribute(ATTRIBNAME, (Object)map, 1);
            createdMap = true;
        }
        PortletSessionBeanHolder holder = new PortletSessionBeanHolder(map, windowId, config);
        holders.set(holder);
        if (isTrace) {
            StringBuilder txt = new StringBuilder(80);
            txt.append("Set portlet session bean holder.");
            txt.append(" ThreadId: ").append(Thread.currentThread().getId());
            txt.append(", PortletSession: ").append(ps.getId());
            txt.append(", WindowId: ").append(windowId);
            txt.append(", Added new BeanMap to session: ").append(createdMap);
            LOG.debug(txt.toString());
        }
    }

    public static void removeBeanHolder() {
        holders.remove();
        if (isTrace) {
            StringBuilder txt = new StringBuilder(80);
            txt.append("Removed portlet session bean holder.");
            txt.append(" ThreadId=").append(Thread.currentThread().getId());
            LOG.debug(txt.toString());
        }
    }

    public static PortletSessionBeanHolder getBeanHolder() {
        return holders.get();
    }

    public static PortletSessionBeanHolder deregister() {
        PortletSessionBeanHolder holder = holders.get();
        holders.remove();
        return holder;
    }

    public static void register(PortletSessionBeanHolder holder) {
        holders.set(holder);
    }

    public <T> T getBean(Contextual<T> bean) {
        String id = null;
        if (this.config.isPortletScoped(bean).booleanValue()) {
            id = this.windowId;
        }
        return this.beans.getBeanInstance(id, bean);
    }

    public <T> void putBeanInstance(Contextual<T> bean, CreationalContext<T> crco, T instance) {
        String id = null;
        if (this.config.isPortletScoped(bean).booleanValue()) {
            id = this.windowId;
        }
        this.beans.putBeanInstance(id, bean, crco, instance);
    }
}

